CREATE TABLE ActivityItem (
    id nvarchar(32) NOT NULL,
    creationDate datetime NOT NULL,
    type nvarchar(255),
    file_activity_id nvarchar(32),
    initiator_account_id nvarchar(255),
    invitation_activity_id nvarchar(32),
    permission_activity_id nvarchar(32)
);
CREATE TABLE FileActivity (
    id nvarchar(32) NOT NULL,
    modificationDate datetime,
    relativePath nvarchar(1024),
    folder_id nvarchar(255)
);
CREATE TABLE PermissionActivity (
    id nvarchar(32) NOT NULL,
    permissionType nvarchar(255),
    folder_id nvarchar(255),
    recipient_account_id nvarchar(255)
);
CREATE TABLE InvitationActivity (
    id nvarchar(32) NOT NULL,
    permissionType nvarchar(255),
    folder_id nvarchar(255),
    recipient_account_id nvarchar(255)
);

ALTER TABLE ActivityItem
    ADD CONSTRAINT activityitem_pkey PRIMARY KEY (id);
ALTER TABLE FileActivity
    ADD CONSTRAINT fileactivity_pkey PRIMARY KEY (id);
ALTER TABLE PermissionActivity
    ADD CONSTRAINT permissionactivity_pkey PRIMARY KEY (id);
ALTER TABLE InvitationActivity
    ADD CONSTRAINT invitationactivity_pkey PRIMARY KEY (id);

ALTER TABLE ActivityItem
    ADD CONSTRAINT FK6ADC16E248795EB2 FOREIGN KEY (file_activity_id) REFERENCES FileActivity(id);
ALTER TABLE ActivityItem
    ADD CONSTRAINT FK6ADC16E29BA772C FOREIGN KEY (invitation_activity_id) REFERENCES InvitationActivity(id);
ALTER TABLE ActivityItem
    ADD CONSTRAINT FK6ADC16E2AA66DC98 FOREIGN KEY (permission_activity_id) REFERENCES PermissionActivity(id);
ALTER TABLE ActivityItem
    ADD CONSTRAINT FK6ADC16E2F74482F3 FOREIGN KEY (initiator_account_id) REFERENCES Account(oid) ON DELETE SET NULL;

CREATE INDEX "IDX_ACTIVITY_TYPE" ON ActivityItem (type);

ALTER TABLE FileActivity
    ADD CONSTRAINT FK5B8264CBD5300DD7 FOREIGN KEY (folder_id) REFERENCES FolderInfo(id);

ALTER TABLE PermissionActivity
    ADD CONSTRAINT FK87D09A1EACF99CC9 FOREIGN KEY (recipient_account_id) REFERENCES Account(oid) ON DELETE SET NULL;
ALTER TABLE PermissionActivity
    ADD CONSTRAINT FK87D09A1ED5300DD7 FOREIGN KEY (folder_id) REFERENCES FolderInfo(id);

ALTER TABLE InvitationActivity
    ADD CONSTRAINT FK13A8E1E8ACF99CC9 FOREIGN KEY (recipient_account_id) REFERENCES Account(oid) ON DELETE SET NULL;
ALTER TABLE InvitationActivity
    ADD CONSTRAINT FK13A8E1E8D5300DD7 FOREIGN KEY (folder_id) REFERENCES FolderInfo(id);
