// ****************************************************************************
// API ************************************************************************
// ****************************************************************************

function showLogApp() {
	setActiveApp("alerts_logs");
	autoRefreshLog(true);
}

function hideLogApp() {
	autoRefreshLog(false);
}

// ****************************************************************************
// LOGIC **********************************************************************
// ****************************************************************************

var refreshTimer;

function refreshLog() {
	var nLines = $('select[name=nLines]').val();
	if (!nLines) {
		nLines = 200;
	}
	$('#logcontainer').load('log', {
		action : "refresh",
		nLines : nLines,
		CSRFToken : csrf_token
	}, function() {
	});
}

function autoRefreshLog(auto) {
	if (refreshTimer) {
		window.clearInterval(refreshTimer);
		refreshTimer = null;
	}
	if (auto) {
		refreshTimer = window.setInterval("refreshLog()", 5000);
		refreshLog();
		$('#pauseButton').show();
		$('#playButton').hide();
	} else {
		$('#pauseButton').hide();
		$('#playButton').show();
	}
}
