function showOrgsApp() {

    setActiveApp('organizations');
    initOrgsApp();

    $('.createOrg').click(function () {
        openEditor();
    });

    $('.orgEditCancel').click(function () {
        cancel();
    });

    $('.orgEditSave').click(function () {
        var formValid = $('#orgEditorForm').validate().form();
        if (formValid) {
            save();
        }
    });

    $('#confirmDeleteBox').click(function () {
        enableDeleteButton();
    });

    $('#orgSetUnlimitedOS').click(function () {
        $('#storageSizeGB').val('9999');
    });

    $('#orgSetUnlimitedUsers').click(function () {
        $('#maxUsers').val('999999999');
    });

    $('#orgClearValidFrom').click(function () {
        $('#OSValidFrom').val('');
    });

    $('#orgSetNeverExpires').click(function () {
        $('#OSValidTill').val('');
    });

    $('#OSValidTill').datepicker({
        minDate: new Date(2007, 1 - 1, 1),
        dateFormat: 'dd M yy',
        changeMonth: true,
        changeYear: true
    });

    $('#OSValidFrom').datepicker({
        minDate: new Date(2007, 1 - 1, 1),
        dateFormat: 'dd M yy',
        changeMonth: true,
        changeYear: true
    });

    $("select[name=skin]").change(function () {
        updateLandingPage();
    });
    updateLandingPage();

    hideEditor();
    showOrgsHome();
}

function showOrgsHome() {
    $('#confirmDelete').hide();
    $('.orgEditor').hide();
    $('.orgEditSave').hide();
    $('.orgEditCancel').hide();

    // PFS-2061: Start
    $("#editLink").hide();
    $("#editUsersLink").hide();
    // PFS-2061: End

    $('.createOrg').show();
    $('.organizationList').show();
    $('.mainFunctionSummary').show();
}

function initOrgsApp() {

    initHomeTable();

    // PFS-1147: Start - auto complete search for organizations.
    var myFunctionDS = new YAHOO.util.FunctionDataSource(refreshHomeTable);
    myFunctionDS.queryMatchContains = true;
    var myAutoComplete = new YAHOO.widget.AutoComplete(
        "organizationHomeSearchInput", "organizationHomeSearchContainer",
        myFunctionDS);
    myAutoComplete.minQueryLength = 0;
    myAutoComplete.applyLocalFilter = false;
    // PFS-1147: End
}

// PFS-2061: Start
var orgID;

$(document).ready(function () {

    function getReturnURL() {
        var returnURL = window.location.href;
        if (returnURL.indexOf("?") >= 0) {
            returnURL = returnURL.substr(0, returnURL.indexOf("?"));
        }
        return returnURL += "?orgID=" + orgID;
    }

    $("#editLink").click(function () {
        if (!orgID) {
            $("#editLink").attr("href", "javascript:void(0);");
            alert(t_org_add_user);
        } else {
            var returnURL = getReturnURL();
            $("#editLink").attr("href", "account?action=createNew" + "&CSRFToken=" + csrf_token
                + "&orgName=" + $("#orgName").val() + "&orgID=" + orgID +
                "&returnURL=" + encodeURIComponent(returnURL));
        }
    });

    var editOrgID = getURLParameter("orgID");

    if (editOrgID) {
        $.getJSON(baseURL + "/wapi/organizations?action=getInfo&OID=" + editOrgID + "&CSRFToken=" + csrf_token,
            function (result) {
                editOrganization(result.name, result.maxUsers, result.basePath, result.storageSize, result.validFrom,
                    result.validTill, result.domains, result.notes, editOrgID, result.skin, result.jsonData);
            });
    }

    $("#editUsersLink").click(function () {
        if (!orgID) {
            $("#editUsersLink").attr("href", "javascript:void(0);");
            alert(t_org_add_user);
        } else {
            $("#editUsersLink").attr("href", "account?" + "&orgID=" + orgID + "&orgName=" + $("#orgName").val() +
                "&CSRFToken=" + csrf_token + "&eU=" + "true");
        }
    });
});
// PFS-2061: End

function updateLandingPage() {
    var skin = $("select[name=skin]").val();
    var landingURL = baseURL;
    if (skin != "(default)") {
        landingURL += "/?skin=" + skin;
    }
    $("#landing_page").attr("href", landingURL);
    $("#landing_page").html(landingURL);
}

function enableDeleteButton() {
    if ($('#confirmDeleteButton').is('input:enabled')) {
        $('#confirmDeleteButton').attr('disabled', 'disabled');
    } else {
        $('#confirmDeleteButton').removeAttr('disabled');
    }
}

function hideDeleteConfirm() {
    $('#confirmDeleteID').val('');
    $('#confirmDelete').hide();
    $('#confirmDeleteButton').attr('disabled', 'disabled');
    $('#confirmDeleteBox').removeAttr('checked');
}

//****************************************************************************
// ORG EDITOR ****************************************************************
//****************************************************************************

function openEditor() {
    // Temporary disabled
    // initAutoComplete();
    orgID = null;

    clearEditor();
    $('.createOrg').hide();
    $('.organizationList').hide();
    $('#confirmDelete').hide();
    $('.mainFunctionSummary').hide();
    $('.mainFunctionsSearch').hide();
    $('#newOrg').val('1');
    $('.orgEditor').show();
    $('.orgEditSave').show();
    $('.orgEditCancel').show();
    focusFirstInputField();
}

function editOrganization(name, maxUsers, basePath, size, validFrom, validTill, domains, notes, oid, skin, jsonData, storageAssigned, isRestricted) {

    orgID = oid;

    clearEditor();

    $('.createOrg').hide();
    $('.organizationList').hide();
    $('#confirmDelete').hide();
    $('.mainFunctionSummary').hide();
    $('.orgEditor').show();
    $('.orgEditSave').show();
    $('.orgEditCancel').show();
    $("#editLink").show();
    $("#editUsersLink").show();

    if (skin) {
        $("select[name=skin] option[value=" + skin + "]").attr('selected', 'selected');
    }

    updateLandingPage();

    if (oid) {

        var domainString = JSON.stringify(domains);
        domainString = domainString.replace(/[\[\]'"]+/g, '').replace(/,/g, '\n');

        size = size / 1024 / 1024 / 1024;

        $("#orgName").val(name);
        $("#maxUsers").val(maxUsers);
        $("#basePath").val(basePath);
        $("#storageSizeGB").val(size);
        $("#OSValidFrom").val(convertDate(validFrom));
        $("#OSValidTill").val(convertDate(validTill));
        $("#domains").val(domainString);
        $("#notes").val(notes);
        $("#jsonData").val(jsonData);
        $("#OID").val(oid);

        if (maxUsers == 999999999) {
            $('#orgSetUnlimitedUsers').attr('checked', 'checked');
            if (!pfs2175) {
                $('#maxUsers').attr('readonly', true);
            }
        } else {
            $('#orgSetUnlimitedUsers').attr('checked', false);
            if (!pfs2175) {
                $('#maxUsers').attr('readonly', false);
            }
        }

        /* PFS-2204: Uncheck when a user value is set */
        if (9999 != size)  {
            $("#orgSetUnlimitedOS").attr("checked", false);
        }

        $('#orgRestrictToDomain').attr('checked', isRestricted);
    }
}

function hideEditor() {
    $('.orgEditSave').hide();
    $('.orgEditCancel').hide();
    $('.orgEditor').hide();
    $('.createOrg').show();
    $('.organizationList').show();
}

function cancel() {
    hideEditor();
    clearEditor();
}

function clearEditor() {
    $('#newOrg').val('0');
    $('#orgName').val('');
    $('#basePath').val('');
    $('#storageSizeGB').val('9999');
    $('#OSValidFrom').val('');
    $('#OSValidTill').val('');
    $('#maxUsers').val('999999999');
    $('#domains').val('');
    $('#notes').val('');
    $('#OID').val('');
}

function save() {
    $('#orgEditorForm').ajaxSubmit(orgEditorFormOptions);
    clearEditor();
}

var orgEditorFormOptions = {
    success: function (responseText, testStatus) {
        refreshHomeTable();
        showOrgsHome();
        logInfo();
    },
    error: function (XMLHttpRequest) {
        logError(XMLHttpRequest.statusText);
    }
};

//****************************************************************************
// INITIALIZE TABLE **********************************************************
//****************************************************************************

var homeListData, homeTable;

function convertDate(millis) {
    if (!millis || millis <= 0) {
        return "";
    }
    // *10/10 ? WTF? Convert to number.
    var oDate = new Date(Number(millis));
    return YAHOO.util.Date.format(oDate, {format: "%d %b %Y"})
}

function refreshHomeTable() {
    homeTable.getRecordSet().reset();
    homeTable.render();
    homeTable.showTableMessage(homeTable.get("MSG_LOADING"),
        YAHOO.widget.DataTable.CLASS_LOADING);
    checkOrganizationSearchRemove();

    homeListData.sendRequest("&query=" + $("#organizationHomeSearchInput").val(),
        homeTable.onDataReturnInitializeTable, homeTable);
}

function initHomeTable() {

    // FORMATTER

    formatActionLink = function (elCell, oRecord, oColumn, ID) {
        var name = oRecord.getData("name");
        var maxUsers = oRecord.getData("maxUsers");
        var basePath = oRecord.getData("basePath");
        var size = oRecord.getData("storageSize");
        var validFrom = oRecord.getData("validFrom");
        var validTill = oRecord.getData("validTill");
        var domains = oRecord.getData("domains");
        var notes = oRecord.getData("notes");
        var isRestricted = oRecord.getData("isRestricted");
        var oid = oRecord.getData("ID");
        var skin = oRecord.getData("skin");
        var jsonData = oRecord.getData("jsonData");

        var val = '<a href="javascript:editOrganization(\'' + escapeXSite(name) + '\',\'' + maxUsers + '\',\'' + basePath + '\',\'' + size + '\',\'' + validFrom + '\',\'' + validTill + '\',\'' + domains + '\',\'' + escapeXSite(notes) + '\',\'' + oid + '\', \'' + skin + '\', \'' + jsonData + '\', \'' + isRestricted + '\')" id="' + ID + '" class="editlink editOrg" title="Edit">&nbsp;</a>';
        if (!pfs2175) {
            val += '<a id="' + ID + '" class="deletelink deleteOrg" title="' + t_remove_org + '">&nbsp;</a>';
        }
        elCell.innerHTML = val;
    };

    var formatDate = function (elCell, oRecord, oColumn, oData) {
        if (oData > 0) {
            var oDate = new Date(oData);
            elCell.innerHTML = YAHOO.util.Date.format(oDate, {format: "%d %b %y"})
                + '<div id="calContainer"></div>';
        } else {
            elCell.innerHTML = "&nbsp;";
        }
    };

    var sizeFormatter = function (elCell, oRecord, oColumn, oData) {
        var content = "";

        var storageAssigned = oRecord.getData("storageAssigned");
        var storageAssignedGB = storageAssigned / 1024 / 1024 / 1024;
        if (storageAssignedGB < 9999) {
            content = formatBytes(storageAssigned);
            content += "/";
        }

        var sizeGB = formatBytes(oData);
        var size = oData / 1024 / 1024 / 1024;
        if (size == 9999) {
            content += "&infin;" + " GB";
        } else {
            content += sizeGB;
        }

        elCell.innerHTML = content;
    };

    var usersFormatter = function (elCell, oRecord, oColumn, oData) {
        if (oData >= 999999999) {
            elCell.innerHTML = oRecord.getData("nUsers") + "/" + "&infin;";
        } else {
            elCell.innerHTML = oRecord.getData("nUsers") + "/" + oData;
        }
    };

    var nameFormatter = function (elCell, oRecord, oColumn, name) {
        var ownOrganization = oRecord.getData("ownOrganization");
        var content = '';
        if (ownOrganization) {
            content += '<a class="ownerlink" title="' + t_main_organization + '">&nbsp;</a>&nbsp;';
        }
        content += escapeXSite(name);
        elCell.innerHTML = content;
    };

    var notesFormatter = function (elCell, oRecord, oColumn, notes) {
        if (notes) {
            elCell.innerHTML = escapeXSite(notes);
        } else {
            elCell.innerHTML = "";
        }
    };
    // TABLE

    var orgColumnDefs = [
        {
            key: "name",
            label: t_name,
            formatter: nameFormatter,
            sortable: true,
            width: 250
        },
        {
            key: "storageSize",
            label: t_size,
            formatter: sizeFormatter,
            sortable: true,
            width: 180
        },
        {
            key: "storageAssigned",
            label: t_size,
            formatter: sizeFormatter,
            sortable: true,
            width: 150,
            hidden: true
        },
        {
            key: "maxUsers",
            label: t_users,
            sortable: true,
            formatter: usersFormatter,
            width: 70
        },
        {
            key: "validFrom",
            label: t_valid_from,
            sortable: true,
            formatter: formatDate,
            width: 70
        },
        {
            key: "validTill",
            label: t_valid_till,
            sortable: true,
            formatter: formatDate,
            width: 70
        },
        {
            key: "nUsers",
            label: t_max_users,
            sortable: true,
            width: 100,
            hidden: true
        },
        {
            key: "notes",
            label: t_notes,
            formatter: notesFormatter,
            sortable: true,
            width: 150
        },
        {
            key: "ID",
            label: "",
            value: "Action",
            formatter: formatActionLink,
            width: 70
        }];

    homeListData = new YAHOO.util.DataSource("organizations?action=getOrganizations&pageSize=501&CSRFToken=" + csrf_token);
    homeListData.responseType = YAHOO.util.DataSource.TYPE_JSON;
    homeListData.connXhrMode = "ignoreStaleResponses";
    homeListData.connMethodPost = true;
    homeListData.responseSchema = {
        resultsList: "ResultSet.Result",
        fields: ["ID", "name", "skin", "domains", "notes", "basePath", "ownOrganization", "storageSize", "validTill", "validFrom", "maxUsers", "nUsers", "storageAssigned", "jsonData", "isRestricted"]
    };

    homeListData.doBeforeCallback = function (oRequest, oFullResponse, oParsedResponse, oCallback) {
        var totalUsers = oFullResponse.ResultSet.totalUsers;
        var totalStorageAssigned = oFullResponse.ResultSet.totalStorageAssigned;

        var summary = "";
        summary += totalUsers + " " + t_users;

        var totalStorageAssignedGB = totalStorageAssigned / 1024 / 1024 / 1024;
        if (totalStorageAssignedGB < 9999) {
            summary += " | ";
            summary += formatBytes(totalStorageAssigned) + " " + t_size;
        }

        $(".mainFunctionSummary").html(summary);

        hideProgress();
        checkAccountHomeResults(oParsedResponse.results.length);

        return oParsedResponse;
    };

    homeTable = new YAHOO.widget.DataTable("organizationListJSON",
        orgColumnDefs,
        homeListData, {
            sortedBy: {
                key: "name",
                dir: "asc"
            },
            MSG_EMPTY: t_no_orgs_found,
            MSG_LOADING: t_loading,
            MSG_SORTASC: t_sort_asc,
            MSG_SORTDESC: t_sort_desc,
            initialLoad: true
        }
    );

    homeTable.subscribe("cellClickEvent", function (oArgs) {
        var oRecord = homeTable.getRecord(oArgs.target);
        var name = oRecord.getData("name");
        var maxUsers = oRecord.getData("maxUsers");
        var basePath = oRecord.getData("basePath");
        var size = oRecord.getData("storageSize");
        var validFrom = oRecord.getData("validFrom");
        var validTill = oRecord.getData("validTill");
        var domains = oRecord.getData("domains");
        var notes = oRecord.getData("notes");
        var oid = oRecord.getData("ID");
        var skin = oRecord.getData("skin");
        var jsonData = oRecord.getData("jsonData");
        var storageAssigned = oRecord.getData("storageAssigned");
        var isRestricted = oRecord.getData("isRestricted");

        // PFS-2194: Show organization name in delete confirm text.
        $("#orgNameSpan").text(" " + name);

        if (oArgs.target.innerHTML.indexOf("deleteOrg") == -1) {
            editOrganization(name, maxUsers, basePath, size, validFrom, validTill, domains, notes, oid, skin, jsonData, storageAssigned, isRestricted);
        }
    });

    homeTable.subscribe("postRenderEvent", function () {
        $(".deleteOrg").overlay({
            target: "#confirmDelete",
            expose: '#f1f1f1',
            onClose: function () {
                $('#confirmDeleteID').attr("value", "");
            }
        });

        $('.deleteOrg').click(function () {
            $('#confirmDeleteID').attr("value", $(this).attr('id'));
        });

    });

    // Automatically edit the first organization in the table when pressing enter.
    $('#organizationHomeSearchInput').keyup(function (e) {
        if (e.keyCode == 13) {
            // Enter
            editIfSingleOrganizationInHome();
        } else if (e.keyCode == 27) {
            // Esc
            clearOrganizationHomeSearchQuery();
        }
    });

    $('#organizationSearchRemove').click(function () {
        clearOrganizationHomeSearchQuery();
    });

    return {
        oDS: homeListData,
        oDT: homeTable
    };
}

function editIfSingleOrganizationInHome() {

    var recordSet = homeTable.getRecordSet();
    if (recordSet.getLength() == 1) {
        var record = recordSet.getRecord(0);
        var OID = record.getData('OID');
        editOrganization(OID);
    }
}

function clearOrganizationHomeSearchQuery() {
    $("#organizationHomeSearchInput").val("");
    checkOrganizationSearchRemove();
    refreshHomeTable();
}

function checkOrganizationSearchRemove() {
    if ($("#organizationHomeSearchInput").val().length > 0) {
        $("#organizationSearchRemove").removeClass();
        $("#organizationSearchRemove").addClass("organizationRemoveResult");
    } else {
        $("#organizationSearchRemove").removeClass();
        $("#organizationSearchRemove").addClass("organizationRemoveResultHide");
    }
}

function checkAccountHomeResults(length) {
    if (length >= 500) {
        logWarning(replaceParams(t_found_more_than, length, 500));
    } else {
        logInfo(replaceParams(t_results_found, length));
    }
}

// ****************************************************************************
// INITIALIZE TABLE **********************************************************
// ****************************************************************************

function initAutoComplete() {
    var adminAutoCompDS = new YAHOO.util.DataSource("organizations?json=1&action=getAccounts&admin=0&orgAdmin=0&CSRFToken=" + csrf_token);
    adminAutoCompDS.responseType = YAHOO.util.DataSource.TYPE_JSON;
    adminAutoCompDS.connXhrMode = "ignoreStaleResponses";
    adminAutoCompDS.connMethodPost = true;
    adminAutoCompDS.responseSchema = {
        resultsList: "ResultSet.Result",
        fields: ["username", "OID", "displayName"]
    };

    var autoComp = new YAHOO.widget.AutoComplete("OrgAdminInput", "OrgAdminContainer", adminAutoCompDS);
    autoComp.queryQuestionMark = false;
    autoComp.formatResult = function (oResultData) {
        var iconURL = baseURL + "/avatars/" + oResultData[2] + ".png";
        return "<img src=\"" + iconURL + "\" widht=\"25\" height=\"25\" />&nbsp;" + oResultData[2];
    };

    autoComp.itemSelectEvent.subscribe(function (sType, aArgs) {
        var oData = aArgs[2];
        var orgOID = oData[1];

        $("#OrgAdminOID").val(orgOID);
    });

    autoComp.dataRequestEvent.subscribe(function () {
        $("#OrgAdminOID").val("");
    });
}