"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

if (!window.Picasso.hasOwnProperty("AccountRecover")) {
    window.Picasso.AccountRecover = {};
}

(function () {

    var handleRecoverAccount = function (e) {
        e.preventDefault();

        var username = $("#recover_username").val();
        var recoveryPhrase = $("#recover_phrase").val();

        if (0 === username.length || 0 === recoveryPhrase.length) {
            Picasso.Notification.show(
                Picasso.Lang.get("notification_error_missing_fields"),
                "warning"
            );

            /* Add marker and focus */
            if (0 === username.length) {
                $("#recover_username").parent("div").addClass("has-error").addClass("has-danger");
                $("#recover_username").focus();
            } else {
                $("#recover_phrase").parent("div").addClass("has-error").addClass("has-danger");
                $("#recover_phrase").focus();
            }
        } else {
            var url = "/account_recover";
            var data = {
                action: "recover",
                username: username,
                recoveryPhrase: recoveryPhrase,
                method: "POST"
            };

            /* Fire ajax */
            Picasso.Helper.fireAjax(url, data,

                /* Success */
                function (data, status) {
                    switch (status) {
                        case 200:
                            Picasso.Notification.show(
                                Picasso.Lang.get("notification_account_recover_success"),
                                "info"
                            );
                            window.location.href = "/login";
                            break;
                    }
                },

                /* Error */
                function (e, status) {
                    switch (status) {
                        case 400:
                            Picasso.Notification.show(
                                Picasso.Lang.get("notification_error_wrong_phrase"),
                                "warning"
                            );
                            break;

                        case 404:
                        case 405:
                            Picasso.Notification.show(
                                Picasso.Lang.get(
                                    "notification_error_unknown_login_or_wrong_phrase",
                                    $("#recover_username").attr("placeholder")
                                ),
                                "danger"
                            );
                            break;

                        default:
                            Picasso.Notification.show(
                                Picasso.Lang.get("notification_error_server_error"),
                                "danger"
                            );

                            Picasso.debugLog(e);
                    }
                }
            );
        }
    };

    /* Bind handler */
    $("#account_recover_form").on("submit", handleRecoverAccount);

})();
