/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {

    /* Bind handlers */
    $("#activation_proxy_settings").click(function (e) {
        e.preventDefault();
        e.stopPropagation();

        /* Show dialog */
        var dialog = new Picasso.Dialog("#activation_proxy_dialog",
            Picasso.Lang.get("dialog_title_settings"),
            Picasso.Lang.get("dialog_body_settings", Picasso.Lang.get("label_proxy")),
            (Picasso.Dialog.Flags.VALIDATE|Picasso.Dialog.Flags.HIDE_ON_ESC|
                Picasso.Dialog.Flags.NO_AUTOCLOSE));

        dialog.setOkHandler(function (inputs) {
            dialog.hide();
        });

        dialog.show();
    });

    $("#activation_form").on("submit", function (e) {
        e.preventDefault();
        e.stopPropagation();



        /*Check validation result*/
        if (!Picasso.Helper.validateInputs(this)) {
             return false;
         }

        /* Check validation result */
        if ($("#activation_submit").hasClass("disabled")) return;

        var data = {
            action: "activateKey"
        };

        /* Collect form data */
        $("input").each(function () {
            var that = $(this);

            data[that.attr("name")] = that.val();
        });

        /* Fetch servers */
        Picasso.Helper.fireAjax("/wapi/license", data,

            /*  Success */
            function (json, status) {
                switch (status) {
                    case 200:
                        /* Falls through */
                    case 201:
                        window.location.href = "/login?Email=admin";
                        break
                }
            },

            /* Error */
            function (e, status) {
                switch (status) {
                    case 400:
                        /* Falls through */
                    case 404:
                        Picasso.Notification.show(
                            Picasso.Lang.get("notification_license_not_found"),
                            "danger");
                        break;
                    case 412:
                        Picasso.Notification.show(
                             Picasso.Lang.get("notification_error_recaptcha_invalid"),
                            "warning");
                        break;

                    default:
                        Picasso.debugLog(e);
                }
            }
        );
    });
})();
