/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {

    /* Bind handlers */
    $("#changepass_form").on("submit", function (e) {

        /* Check validation result */
        if (!Picasso.Helper.validateInputs(this)) {
            e.preventDefault();
            e.stopPropagation();

            Picasso.Notification.show(
                Picasso.Lang.get("notification_error_missing_fields"),
                "warning");

            return;
        }
    });

    $(".pica-password").each(function () {
        var that = $(this);

        Picasso.Helper.updatePasswordPolicy(that);

        /* Add change handler to update policy info */
        that.on("keyup", function (e) {
            Picasso.Helper.updatePasswordPolicy(this,
                e.originalEvent.target.value);
        });

        /* Add click handler to clear button to update policy as well */
        that.siblings(
            ".pica-input-clear").click(function () {
            Picasso.Helper.updatePasswordPolicy(that);
        });
    });
})();