/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {

    var baseurl = window.location.protocol + "//" + window.location.host + "/";

    $(document).ready(function () {

        function adjustLayout() {
            const navbarHeight = $(".navbar-fixed-top").height();
            const searchHeight = $("#pica_action_search").height();
            const linkTop = navbarHeight + searchHeight * 2;

            /*if (navbarHeight > 100) {*/
                $("body").css("padding-top", navbarHeight + searchHeight);
                $(".pica_link").css("top", linkTop);
/*
            }
*/
        }

        $(window).on('resize', adjustLayout);

        screen.orientation.addEventListener("change", adjustLayout);


        Picasso.Helper.fireAjax("/wapi/config", {},

            function (json) {
                sessionStorage.setItem("openConfig", JSON.stringify(json.ResultSet.Result[0]));
            },
        );

    })


    /**
     * Handle click on upload button
     **/

    var handleClickUpload = function () {
        var upload = new Picasso.Dialog.Upload(Picasso.Lang.get("dialog_title_upload"),
            Picasso.Lang.get("dialog_body_upload",
                Picasso.Lang.get(Picasso.Lang.Flags.DOWNCASE, "label_links")));

        /* Append token if any */
        var token = $("#filelink_token").val();
        var cwd = Picasso.get("cwd");
        if (cwd){
            upload.setData({
                folderID: cwd.getFolderId(),
                path: cwd.getPath(),
                uploadToken: token,
                fileLinkId: $("#filelink_id").val()
            });
        }
        upload.setDoneHandler(function () {
                Picasso.Files.fetch(cwd);
            }
        );

        upload.setUrl("/ul/" + $("#filelink_id").val());


        upload.show();
    };

    /**
     * Handle click on QR button
     **/

    var handleClickQr = function () {

        var dialog = new Picasso.Dialog("#pica_canvas_dialog",
            Picasso.Lang.get("dialog_title_link",$("#filelink_name").val()));

        dialog.setAssignHandler(function () {
            var canvas = document.getElementById("board")
            var qrcode = new QRious({
                element: canvas,
                background: '#ffffff',
                backgroundAlpha: 1,
                foreground: '#000000',
                foregroundAlpha: 1,
                level: 'H',
                padding: 0,
                size: 300,
                value: baseurl+"getlink/"+$("#filelink_id").val()
            });

        });

        dialog.show()
    };

    /**
     * Handle click on download button
     *
     * @param {Event}  e  Click event
     **/

    var handleClickDownload = function (e) {
        e.preventDefault();
        e.stopPropagation();

        var token = $("#filelink_token").val();
        var url = $(this).attr("href");

        if (0 < token.length) {
            if (-1 === url.indexOf("?")) {
                url += "?token=" + token;
            } else {
                url += "&token=" + token;
            }
        }

        window.location.assign(url);
    };

    /**
     * Handle click on copy button
     *
     * @param {Event}  e  Click event
     **/

    var handleClickCopyToClip = function (e) {
        var that = $(this);

        Picasso.Helper.copyToClipboard.apply(that, that.parent().children("input"));
    };

    var handleClickSettings = function () {
            var fileLinkId = document.getElementById('filelink_id').value;

            Picasso.Link.getLink(fileLinkId, function (link, status) {
                switch (status) {
                    case 200:
                        var linkDialog = new Picasso.Dialog.Link();
                        linkDialog.edit(link, function () {
                            console.log('Link edited successfully.');
                            location.reload();
                        }, function (error) {
                            console.error('Error editing link:', error);
                        });
                        break;
                    default:
                        console.error('Unexpected status code:', status);
                        break;
                }
            }, function (error) {
                console.error('Error getting link details:', error);
            });
    }

    /* Bind handlers */
    $("#filelink_copy").click(handleClickCopyToClip);
    $("#filelink_download").click(handleClickDownload);
    $("#filelink_upload").click(handleClickUpload);
    $("#filelink_qr").click(handleClickQr);
    $("#link_settings").click(handleClickSettings);

    /* Sanitize url */
    var input = $('input[type="text"]');

    input.val(Picasso.Helper.sanitizeUrl(input.val()));
})();
