/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {
    var EXTENSION_MAP = {
        "docx": "text",
        "txt": "text",
        "xlsx": "spreadsheet",
        "csv": "spreadsheet",
        "pptx": "presentation"
    };

    var MODE_MAP = {
        "USER_EDIT": "edit",
        "COLLABORATIVE_EDIT": "edit",
        "USER_VIEW": "edit"
    };

    var TOUCH_TIMER;

    /**
     * Handle errors
     *
     * @param xhr
     * @param status
     * @param e
     **/

    var handleErrors = function (xhr, status, e) {
        /* Clear timeout if any */
        /*if (null !== TOUCH_TIMER) {
            clearTimeout(TOUCH_TIMER);
        }*/

        Picasso.Notification.show(
            Picasso.Lang.get("notification_error_cannot_save_document"), "danger");

        Picasso.debugLog(e);
    };

    /**
     * Send touch event to OnlyOffice server
     **/

    var sendTouch = function() {

        var backendUrl = Picasso.get("ooBackendUrl");

        /* If this is an federated file, we need the federated access token for proxying */
        var federatedToken = Picasso.get("federatedToken");
        if (federatedToken) {
            backendUrl += "?federatedToken=" + federatedToken;
        }
        var token = Picasso.get("token");
        if (token) {
            backendUrl += "?Token=" + token;
        }

        $.ajax({

            /* Add CSRF Token header */
            beforeSend: function(request) {
                request.setRequestHeader("X-CSRFToken", Picasso.get("CSRF"));
            },

            type: "POST",
            url: backendUrl,
            data: {
                action: "touch"
            },

            error: handleErrors
        });
    };

    /* Init */
    if (window.hasOwnProperty("DocsAPI")) {

        var account = Picasso.get("account");
        var callbackUrl = Picasso.get("ooBackendUrl") + "?CSRFToken=" + Picasso.get("CSRF");

        /* If this is an federated file, we need the federated access token for proxying */
        var federatedToken = Picasso.get("federatedToken");
        if (federatedToken) {
            callbackUrl += "&federatedToken=" + federatedToken;
        }
        var token = Picasso.get("token");
        if (token) {
            callbackUrl += "&Token=" + token;
        }

        var config = {
            type: (500 < $(window).width() ? "desktop" : "mobile"),
            width: "100%",
            height: "100%",
            documentType: EXTENSION_MAP[Picasso.get("fileExt")],
            document: {
                key: Picasso.get("ooSessionId"),
                url: callbackUrl + "&action=download",

                title: Picasso.get("fileName"),
                fileType: Picasso.get("fileExt"),
                permissions: {
                    edit: Picasso.get("fileEdit"),
                    comment: Picasso.get("fileEdit"),
                    download: Picasso.get("fileDownload"),
                    print: Picasso.get("fileDownload")
                },
                info: {
                    author: account.getDisplayName()
                }
            },
            editorConfig: {
                callbackUrl: callbackUrl + "&action=save",
                lang: Picasso.Lang.LANG,
                mode: MODE_MAP[Picasso.get("ooEditorMode")],
                user: {
                    id: account.getOid(),
                    firstname: account.getFirstName(),
                    lastname: account.getLastName(),
                    name: account.getDisplayName()
                },
                customization: {
                    chat: true,
                    comments: Picasso.get("fileEdit"),
                    goback: {
                        text: Picasso.Lang.get("label_imprint"),
                        url: Picasso.get("imprintUrl")
                    },
                    customer: {
                        address: "Rheinpromenade 4a, 40789 Monheim am Rhein",
                        mail: "support@powerfolder.com",
                        name: "PowerFolder - dal33t GmbH",
                        www: "https://powerfolder.com"
                    },
                    compactHeader: true,
                    toolbarNoTabs: true,
                    logo: {
                        visible: false,
                        image: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        imageDark: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        imageEmbedded: "data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=",
                        url: "https://powerfolder.com"
                    },
                    features: {
                        featuresTips: false,
                    }
                },
                events: {

                    "onSave": function (e) {
                        var data = {
                            "action": "save",
                            "status": 2,
                            "url": e.data
                        };

                        $.ajax({
                            type: "POST",
                            url: Picasso.get("ooBackEndUrl"),
                            data: data,
                            error: handleErrors
                        });
                    },

                    "onDocumentStateChange": function () {
                        /* Nothing to do here? */
                    }
                }
            }
        };

        Picasso.Helper.fireAjax(Picasso.get("ooBackendUrl"), {
            method: "POST", action: "signConfig", configJson: JSON.stringify(config)
        }, function (res) {
            if (res.token) {
                config.token = res.token;
            }
            new DocsAPI.DocEditor("editor", config);
        }, function (e,status) {
            switch (status) {
                case 400:
                    Picasso.Notification.show(Picasso.Lang.get("notification_jwt_signature_failed"), "danger");
                    break;
                default:
                    Picasso.Notification.show(Picasso.Lang.get("notification_error"), "danger");
                    break;
            }

        });

        /* Start touch timer */
        TOUCH_TIMER = setInterval(sendTouch,
            Math.round(Picasso.get("ooSessionTimeout") / 4));
    } else {
        Picasso.Notification.show(
            Picasso.Lang.get("notification_error_cannot_create_document"),
            "danger");
    }
})();
