ALTER TABLE Account ALTER COLUMN encodedRecoveryPhrase NVARCHAR(255);

DROP INDEX IF EXISTS Account.IDX_ACC_FIRSTNAME;
ALTER TABLE Account ALTER COLUMN firstname NVARCHAR(127);
CREATE INDEX IDX_ACC_FIRSTNAME ON Account (firstname);

DROP INDEX IF EXISTS Account.IDX_ACC_SURNAME;
ALTER TABLE Account ALTER COLUMN surname NVARCHAR(63);
CREATE INDEX IDX_ACC_SURNAME ON Account (surname);

ALTER TABLE Account ALTER COLUMN title NVARCHAR(63);
ALTER TABLE Account ALTER COLUMN telephone NVARCHAR(63);
ALTER TABLE Account ALTER COLUMN jsonData NVARCHAR(2047);
ALTER TABLE Account ALTER COLUMN language NVARCHAR(15);

DROP INDEX IF EXISTS Account.IDX_AOTP;
ALTER TABLE Account ALTER COLUMN otp NVARCHAR(127);
CREATE INDEX IDX_AOTP ON Account (otp);

ALTER TABLE Account ALTER COLUMN notes NVARCHAR(2047);
ALTER TABLE Account ALTER COLUMN basePath NVARCHAR(511);

# SP_RENAME 'Account.token_2fa', 'twoFactorAuthenticationToken', 'COLUMN';
# ALTER TABLE Account ALTER COLUMN twoFactorAuthenticationToken NVARCHAR(511);
ALTER TABLE Account ADD twoFactorAuthenticationToken varchar(511);
UPDATE Account SET twoFactorAuthenticationToken = token_2fa;

DROP INDEX IF EXISTS Account.IDX_SHIB_PID;
ALTER TABLE Account ALTER COLUMN shibbolethPersistentID NVARCHAR(2047);
CREATE INDEX IDX_SHIB_PID ON Account (shibbolethPersistentID);

DROP INDEX IF EXISTS Account.IDX_LDAPDN;
ALTER TABLE Account ALTER COLUMN ldapDN NVARCHAR(511);
CREATE INDEX IDX_LDAPDN ON Account (ldapDN);