// ****************************************************************************
// API ************************************************************************
// ****************************************************************************

function showAccountApp(startQuery) {
    setActiveApp("accounts");
    // Show my (starting) elements
    hideAccountApp();

    // Load and init application
    $("#accountHomeSearchInput").val(startQuery);
    initAccountApp(true);
    showAccountHome();
}

function showCreateAccount() {
    // Show my (starting) elements
    hideAccountApp();
    // Load and init application
    initAccountApp(false);
    createAccount();
}

// PFS-2061: Start
var returnURL = getURLParameter("returnURL");
var orgName = getURLParameter("orgName");
var orgID = getURLParameter("orgID");
var editUsers = getURLParameter("eU");

$(document).ready(function () {

    $("#backToOrg").hide();

    if (orgID) {
        $("#csvExportButton").hide();

        $("#backToOrg").show();
        $("#backToOrgLink").attr("href", "/admin/organizations" + "?orgID=" + orgID);
        $("#organizationInput").val(orgName);

        if (editUsers) {
            returnURL = "account?&orgID=" + orgID + "&orgName=" + orgName + "&CSRFToken=" + csrf_token;
            $("#addAccount").attr("href", "account?action=createNew" + "&CSRFToken=" + csrf_token +
                "&orgName=" + orgName + "&orgID=" + orgID + "&returnURL=" + encodeURIComponent(returnURL));
        }
    }

});

// PFS-2061: End

function hideAccountApp() {
    // Hide ALL my elements
    $('.accountHomeList').hide();
    $('.accountEditMenu').hide();
    $('.mainFunctionsSearch').hide();
    $('.accountEditMain').hide();
    $('.accountEditInfo').hide();
    $('.accountEditPermissionTab').hide();
    $('.accountEditGroupTab').hide();
    $('.accountmain').hide();
    $('.accountedit').hide();
    $('.sortContainer').hide();
}

// ****************************************************************************
// EDITOR *********************************************************************
// ****************************************************************************

var accountOID;
var accountPermissionTable;
var accountNewObject;

function createAccount() {
    editAccount(createUUID(), true, false);
}

function editAccount(OID) {
    editAccount(OID, false, false);
}

function editAccount(OID, newObject, startWithPermissions) {
    accountOID = OID;
    accountNewObject = newObject;
    $('.mainFunctionsSearch').hide();
    $('.accountmain').hide();
    $('.accountedit').show();
    $('.sortContainer').hide();
    initAccountEditorMainTab(newObject, startWithPermissions);
    initAccountPermissionsTable();
    initAccountGroupsTable();
}

function deleteAccount(OID) {
    if (confirm(t_confirm_delete_account)) {
        // Delete account
        $.get("account.edit", {
            action: "deleteAccount",
            OID: OID,
            CSRFToken: csrf_token
        }, function () {
            // Reload HOME list
            if (!returnURL) {
                refreshAccountHome();
                showAccountHome();
            } else {
                window.location.href = returnURL;
            }
        });
    }
}

function cancelAccount() {
    hideAccountApp();
    // Reload HOME list

    if (!returnURL) {
        refreshAccountHome();
        showAccountHome();
    } else {
        window.location.href = returnURL;
    }
}

function saveAccount() {
    var formValid = $("#accountEditMainForm").validate().form();
    var passwordSet = $("#password1").length;
    if ("PASSWORD_UNCHANGED" == $("#password1").val()) {
        passwordOk = true;
    }
    if (formValid && (!passwordSet || passwordOk)) {
        $('#accountEditMainForm').ajaxSubmit(accountEditMainFormOptions);
        return false;
    }
}

var accountEditMainFormOptions = {
    beforeSend: function (jqXHR, settings) {
        $('#emails option').each(function () {
            settings.data += '&emails=' + $(this).attr('value');
        });
    },
    success: function (responseText, textStatus) {

        var removeTrials = responseText.indexOf("REMOVE TRIAL LICENSES") >= 0;
        saveLicenseKeys(removeTrials);
        // Method also refreshes and switches to HOME after success
        saveFolderPermissions();
    },
    error: function (XMLHttpRequest) {
        var errorMsg = XMLHttpRequest.statusText;
        logError(errorMsg);
        if (errorMsg === "Forbidden")
            window.location.replace("../folderstable");
    }
};

function saveFolderPermissions() {
    if (!permissionsLoaded) {
        return;
    }
    var recordSet = accountPermissionTable.getRecordSet();
    var permSaveURI = 'action=saveFolderPermissions&CSRFToken=' + csrf_token + '&OID=' + encodeURIComponent(accountOID);
    for (var i = 0; i < recordSet.getLength(); i++) {
        var record = recordSet.getRecord(i);
        var folderID = record.getData('folderID');
        var folderName = record.getData('folderName');
        var permission = record.getData('permission');
        permSaveURI += '&folderID=' + encodeURIComponent(folderID);
        permSaveURI += '&folderName=' + encodeURIComponent(folderName);
        permSaveURI += '&permission=' + encodeURIComponent(permission);
    }
    // Save permissions
    $.get("account.edit", permSaveURI, function () {
        saveGroupList();
    });
}

function saveGroupList() {
    if (!groupsLoaded) {
        return;
    }
    var recordSet = accountGroupTable.getRecordSet();
    var groupSaveURI = 'action=saveGroupList&CSRFToken=' + csrf_token + '&OID=' + encodeURIComponent(accountOID);
    for (var i = 0; i < recordSet.getLength(); i++) {
        var record = recordSet.getRecord(i);
        var groupID = record.getData('OID');
        groupSaveURI += '&groupID=' + encodeURIComponent(groupID);
    }

    $.post("account.edit", groupSaveURI, function () {
        // Reload HOME list

        if (!returnURL) {
            refreshAccountHome();
            showAccountHome();
        } else {
            window.location.href = returnURL;
        }
    });
}

function saveLicenseKeys(removeTrials) {
    $("#accountLicenseKeyStore").hide();
    $form = $("<form action='account.edit' method='POST'></form>");
    $form.append("<input type='hidden' name='action' value='saveLicenseKeys' />");
    $form.append("<input type='hidden' name='OID' value='" + accountOID + "' />");
    $form.append('<input type="hidden" name="CSRFToken" value="' + csrf_token + '" />');
    if (removeTrials) {
        $form.append("<input type='hidden' name='removeTrials' value='true' />");
    }

    // var saveURI = 'action=saveLicenseKeys&OID=' + encodeURIComponent(accountOID);
    $('#accountEditMainForm select[name=licenses]').find('option').each(
        function () {
            $form.append("<input type='hidden' name='fileName' value='" + $(this).val() + "' />");
            // saveURI += "&fileName=";
            // saveURI += encodeURIComponent($(this).val());
        });
    // if (removeTrials) {
    // 	saveURI += "&removeTrials=true";
    // }
    // Don't execute GET.
    // $.get("account.edit", saveURI);

    // Use POST / Form
    $("#accountLicenseKeyStore").html("");
    $("#accountLicenseKeyStore").append($form);
    $form.ajaxSubmit(accountSaveLicenseKeyForm);
}

var accountSaveLicenseKeyForm = {
    success: function (responseText, textStatus) {
    },
    error: function (XMLHttpRequest) {
        logError(XMLHttpRequest.statusText);
    }
};

function accountAddFolder() {
    var folderName = $("#accountEditAddFolderInput").val();
    var permission = $("#accountAddFolderPermission").val();
    var folderID = $("#accountAddFolderID").val();

    if (folderName.length === 0) {
        // Do nothing
        return;
    }
    if (folderID.length === 0) {
        // New folder
        lastSelectedFolderSync = "(new)";
        lastSelectedFolderFiles = 0;
        lastSelectedFolderSize = 0;
        permission = "OWNER";
    }

    if (folderID.length === 0 || !containedInPermissionsTable(folderID)) {
        accountPermissionTable.addRow({
            folderName: folderName,
            permission: permission,
            folderID: folderID,
            folderSync: lastSelectedFolderSync,
            folderFiles: lastSelectedFolderFiles,
            folderSize: lastSelectedFolderSize
        });
    }

    // Clear values. Start from scratch.
    $("#accountEditAddFolderInput").val("");
    $("#accountAddFolderID").val("");
}

function accountAddGroup() {
    var groupName = $('#accountEditGroupInput').val();
    var groupID = $('#accountAddGroupID').val();

    if (groupName.length === 0) {
        return;
    }

    if (groupID.length === 0) {
        return;
    }

    if (!containedInGroupTable(groupID)) {
        accountGroupTable.addRow({
            groupname: groupName,
            OID: groupID
        });
    }

    $('#accountEditGroupInput').val("");
    $('#accountAddGroupID').val();
}

function showAccountEditor() {
    $('.accountHomeList').hide();
    $('.accountEditMain').show();
    $('.accountEditMenu').show();
    $('.accountEditPermissionTab').hide();
    $('.accountEditGroupTab').hide();
    $('.accountEditMainTab').show();
    $('.accountEditForm').show();
    $('.accountEditInfo').show();
    $('.account').show();
    $("#licenseOverlay").data("overlay").close();
    focusFirstInputField();
}

function showAccountMainTab() {
    $('.accountEditPermissionTab').hide();
    $('.accountEditGroupTab').hide();
    $('.accountEditMenu').show();
    $('.accountEditMain').show();
    $('.accountEditInfo').show();
    $('.mainFunctionsSearch').hide();
    $('.accountEditMainTab').show();
    $('.accountmain').hide();
    focusFirstInputField();
}

function showAccountPermissionsTab() {
    hideAccountApp();
    $('.accountEditMenu').show();
    $('.accountEditPermissionTab').show();
    $('.accountEditGroupTab').hide();
    $('.mainFunctionsSearch').hide();
    $('.accountmain').hide();
    $('.accountedit').show();
    focusFirstInputField();
}

function showAccountGroupsTab() {
    hideAccountApp();
    $('.accountEditMenu').show();
    $('.accountEditPermissionTab').hide();
    $('.accountEditGroupTab').show();
    $('.mainFunctionsSearch').hide();
    $('.accountmain').hide();
    $('.accountedit').show();
    focusFirstInputField();
}

function initAccountApp(refreshHome) {
    hideAccountApp();

    // Form.
    $('#accountEditMainForm').submit(function () {
        saveAccount();
        return false;
    });

    // Event handling for tabs
    $('.accountShowMainTab').click(function () {
        showAccountMainTab();
    });

    $('.accountShowPermissionsTab').click(function () {
        showAccountPermissionsTab();
    });

    $('.accountShowGroupsTab').click(function () {
        showAccountGroupsTab();
    });

    $('#accountAddFolderForm').submit(function () {
        accountAddFolder();
        return false;
    });

    $('#accountAddGroupForm').submit(function () {
        accountAddGroup();
        return false;
    });

    // Buttons
    $('.accountEditSave').click(function () {
        saveAccount();
        return false;
    });

    $('.accountEditDelete').click(function () {
        deleteAccount(accountOID);
    });

    $('.accountEditCancel').click(function () {
        cancelAccount();
    });

    initAccountHome();
    if (refreshHome) {
        refreshAccountHome();
    }

    $('.mainFunctionsSearch').show();

}

function initAccountEditorMainTab(newObject, startWithPermissions) {

    if (orgID) {
        var accToOrgLink = "action=getMainTab&newObject=" + (newObject ? "true" : "false") + "&CSRFToken=" + csrf_token +
            "&OID=" + encodeURIComponent(accountOID) + "&orgName=" + orgName + "&orgID=" + orgID;
    } else {
        var accToOrgLink = "action=getMainTab&newObject=" + (newObject ? "true" : "false") + "&CSRFToken=" + csrf_token +
            "&OID=" + encodeURIComponent(accountOID);
    }

    $('#accountEditMainTab').load(
        "account.edit",
        accToOrgLink,
        function () {
            // Initialize
            $("#accountMoveData").hide();
            // Create new account if necessary
            $("#accountEditMainForm select[name=serverNodeID]").change(
                function () {
                    $("#accountMoveData").show();
                });

            $('#accountEditMainForm').validate({
                submitHandler: function (form) {
                    saveAccount();
                    return false;
                }
            });

            $('#OSValidFrom').datepicker({
                minDate: new Date(2007, 1 - 1, 1),
                dateFormat: 'dd M yy',
                changeMonth: true,
                changeYear: true
            });

            $('#accountClearValidFrom').click(function () {
                $("#OSValidFrom").val("");
                $("#accountEditMainForm").validate().form();
            });

            $('#OSValidTill').datepicker({
                minDate: new Date(2007, 1 - 1, 1),
                dateFormat: 'dd M yy',
                changeMonth: true,
                changeYear: true
            });

            $('#setAutoRenewDevicesUnlimted').click(function () {
                $("input[name=autoRenewDevices]").val("999");
                $("#accountEditMainForm").validate().form();
            });

            $('#addEmail').click(addEmailToList);
            $('#deleteEmail').click(deleteEmailFromList);

            $('#accountSetNeverExpires').click(function () {
                $("#OSValidTill").val("");
                // Revalidate form
                $("#accountEditMainForm").validate().form();
            });

            $('#accountSetUnlimitedOS').click(function () {
                $("#OSSize").val("9999.00");
                // Revalidate form
                $("#accountEditMainForm").validate().form();
            });


            $("#licenseOverlay").html($("#innerLicenseOverlay").html());
            $("#licenseOverlay").addClass("overlayaction");
            $("#innerLicenseOverlay").hide();
            $("#licenseOverlay").overlay({
                target: "#licenseOverlay",
                expose: '#f1f1f1',
                onLoad: function () {
                    $("input[name='proLicenses']").focus();
                    getValidLicenses();
                    $("#licenseEmailTrial").val($("input[name=username]").val());
                    $("#licenseEmailReuse").val($("input[name=username]").val());
                    $("#licenseEmail").val($("input[name=username]").val());
                }
            });
            $('#loader').hide();
            $('.close').click(function () {
                $("#licenseOverlay").data("overlay").close();
            });

            $('#setAutoRenewDevicesUnlimted').click(function () {
                $("#accountEditMainForm input[name=autoRenewDevices]").val("999");
            });

            $('#accountLicenseRemove').click(function () {
                removeAccountSelectedLicenseKey();
                $("#licenseOverlay").data("overlay").close();
            });

            $('#accountLicenseAdd').click(function () {
                if (!$("#accountEditMainForm").validate().form()) {
                    alert(t_required_fields);
                } else {
                    $("#licenseOverlay").data("overlay").load();
                }
            });

            // License file upload form
            $('#accountLicenseUpload').submit(function () {
                $(this).ajaxSubmit(accountLicenseUploadOptions);
                return false;
            });

            // License request form
            $('#accountLicenseRequest').submit(function () {
                var selectedKey = $("select[name=licenseContent]").val().indexOf('-') !== 0;

                if (selectedKey) {
                    $('#accountLicenseReuse').ajaxSubmit(accountLicenseRequestOptions);
                    return false;
                }
                if (!selectedKey && $("#accountLicenseRequest").validate().form()) {
                    $(this).ajaxSubmit(accountLicenseRequestOptions);
                }
                return false;
            });

            // License re-use form
            $('#accountLicenseReuse').submit(function () {
                var isKey = $("select[name=licenseContent]").val().indexOf('-') !== 0;
                if (isKey) {
                    $(this).ajaxSubmit(accountLicenseRequestOptions);
                }
                return false;
            });

            // License trial request form
            $('#accountLicenseTrialRequest').submit(function () {
                if ($("#accountLicenseTrialRequest").validate().form()) {
                    $(this).ajaxSubmit(accountLicenseRequestOptions);
                }
                return false;
            });

            // Create new account if necessary
            $("#accountEditMainForm input[name=newObject]").val(newObject);

            if (orgID == null) {
                if (pAdmin === true || pOrgCreate === true) {
                    initOrgAutoComplete();
                }
            }

            showAccountEditor();
            if (startWithPermissions) {
                showAccountPermissionsTab();
                showAccountGroupsTab();
            }

            $('#accountEditMainForm input[name=username]').keyup(
                function (e) {
                    if (e.keyCode == 13) {
                        // Enter Do nothing
                    } else if (e.keyCode == 27) {
                        // Esc
                        cancelAccount();
                    }
                });

            initTooltip(".accountWarning");
        });
}

var addEmailToList = function () {
    var newEmail = $('#emailToAdd').val();

    if (newEmail.trim() === "") {
        return;
    }

    var emailExists = false;

    $('#emails option').each(function () {
        if (newEmail.trim() === $(this).val()) {
            emailExists = true;
        }
    });

    if (emailExists) {
        return;
    }

    $.ajax({
        url: baseURL + "/admin/account.edit",
        data: {
            action: "isEmailInUse",
            email: newEmail,
            OID: accountOID,
            newObject: accountNewObject
        },
        dataType: "json",
        method: "GET",
        error: function (jqXHR, textStatus, errorThrown) {
            try {
                // Log the message
                var data = JSON.parse(jqXHR.statusText);
                logInfo(data.message);

                if (data.federated) {
                    $("#mergeForm").css("display", "none");
                    $('#mergeMessage').html($("#mergeMessageError").val());
                } else {
                    // Fill in the username of the merging and email address of the account to be merged
                    var replaced = $('#mergeMessage').html().replace('{0}', "'" + $('input[name=username]').val() + "'");
                    $('#mergeMessage').html(replaced);
                    replaced = $('#mergeMessage').html().replace('{1}', "'" + $('#emailToAdd').val() + "'");
                    $('#mergeMessage').html(replaced);

                    $('#accountToMerge').attr('value', data.toMergeOID);
                }

                // Show the overlay
                $('#mergeAccount').data('overlay').load();
            } catch (err) {
                logError(jqXHR.statusText);
            }
        },
        success: function (data, textstatus, jqXHR) {
            $('#emails').append($('<option>', {text: newEmail, value: newEmail}));
            $('#emailToAdd').val("");
            logInfo(JSON.parse(data).message);
        }
    });
};

var deleteEmailFromList = function () {
    $('#emails').find('option:selected').remove();
};

var accountLicenseUploadOptions = {
    beforeSubmit: function () {
        logInfo(t_uploading_file);
        $('#loader').show();
        return true;
    },
    success: function (responseText, textStatus) {
        var eStart = responseText.indexOf('Exception:');
        responseText = responseText.replace("<pre>", "");
        responseText = responseText.replace("</pre>", "");

        if (eStart > 0) {
            // WORKAROUND, Error handler does not work with jquery forms and
            // file upload?
            var eEnd = responseText.indexOf("</", eStart);
            var errorMsg = responseText.substring(eStart + 10, eEnd);
            logError(errorMsg);
        } else {
            var result = eval('(' + responseText + ')');
            for (var i = 0; i < result.length; i++) {
                var licKey = result[i];
                addAccountLicenseKey(licKey.fileName, licKey.info);
                logInfo(replaceParams(t_uploaded_license, licKey.info));
            }
            $("#licenseOverlay").data("overlay").close();
            $('#loader').hide();
        }
    },
    // Gets never called.
    error: function (XMLHttpRequest) {
        logError(XMLHttpRequest.statusText);
    }
};

var accountLicenseRequestOptions = {
    beforeSubmit: function () {
        logInfo(t_requesting_license);
        $('.licenseRequestSubmit').attr('disabled', 'disabled');

        // TODO: Clean up this MESS:
        $("input[name=email]").val($("input[name=username]").val());
        $("input[name=accountOID]").val(accountOID);
        $("#licenseEmailTrial").val($("input[name=username]").val());
        $("#licenseEmailReuse").val($("input[name=username]").val());
        $("#licenseEmail").val($("input[name=username]").val());

        $('#loader').show();
        return true;
    },
    success: function (result, textStatus) {
        for (var i = 0; i < result.length; i++) {
            var licKey = result[i];
            addAccountLicenseKey(licKey.fileName, licKey.info);
            logInfo(replaceParams(t_obtained_license, licKey.info));
            $("#licenseOverlay").data("overlay").close();
            $('#loader').hide();
            $('.licenseRequestSubmit').attr('disabled', '');
        }
    },
    error: function (XMLHttpRequest) {
        $('#loader').hide();
        logError(XMLHttpRequest.statusText);
        $('.licenseRequestSubmit').attr('disabled', '');
        alert(XMLHttpRequest.statusText);
    }
};

function addAccountLicenseKey(fileName, info) {
    $('#accountEditMainForm select[name=licenses]').append(
        $('<option selected></option>').val(fileName).html(info));
    // alert("License key added. fileName: " + fileName + ", info: " + info);
}

function removeAccountSelectedLicenseKey() {
    $("#accountEditMainForm select[name=licenses] option:selected").remove();
}

var lastSelectedFolderSync = "";
var lastSelectedFolderFiles = "";
var lastSelectedFolderSize = "";
var permissionsLoaded = false;

function initAccountPermissionsTable() {
    var permissionFormatter = function (elCell, oRecord, oColumn, permission) {
        if (permission == "NO_ACCESS") {
            elCell.innerHTML = t_perm_no_access;
        } else if (permission == "READ") {
            elCell.innerHTML = t_perm_read;
        } else if (permission == "READ_WRITE") {
            elCell.innerHTML = t_perm_read_write;
        } else if (permission == "ADMIN") {
            elCell.innerHTML = t_perm_admin;
        } else if (permission == "OWNER") {
            elCell.innerHTML = t_perm_owner;
        }
    };

    var ddOptions = [
        {label: t_perm_no_access, value: "NO_ACCESS"},
        {label: t_perm_read, value: "READ"},
        {label: t_perm_read_write, value: "READ_WRITE"}
    ];

    if (show_folder_admin === true) {
        ddOptions[ddOptions.length] = {label: t_perm_admin, value: "ADMIN"};
    }

    var permissionEditor = new YAHOO.widget.DropdownCellEditor({
        multiple: false,
        disableBtns: true,
        dropdownOptions: ddOptions
    });

    var bytesFormatter = function (elCell, oRecord, oColumn, number) {
        elCell.innerHTML = formatBytes(number);
    };

    var syncFormatter = function (elCell, oRecord, oColumn, sync) {
        if (sync == "(new)") {
            elCell.innerHTML = sync;
            return;
        }
        elCell.innerHTML = formatSyncPercentage(sync);
    };

    var nameFormatter = function (elCell, oRecord, oColumn, folderName) {
        var resourceURL = oRecord.getData("resourceURL");
        var iconURL;
        if (resourceURL) {
            iconURL = "../skin/images/folder_white.png";
        } else {
            iconURL = "../skin/images/folder_offline.png";
        }
        if (oRecord.getData("isInvitation") === true) {
            folderName = folderName + " (" + t_invitation + ")";
        }

        elCell.innerHTML = formatTableName(folderName, iconURL, resourceURL);
    };

    var myPermissionDefs = [{
        key: "folderName",
        label: t_folder,
        sortable: true,
        resizeable: true,
        width: 300,
        formatter: nameFormatter
    }, {
        key: "folderSync",
        label: t_sync,
        sortable: true,
        resizeable: true,
        width: 50,
        formatter: syncFormatter
    }, {
        key: "folderFiles",
        label: t_files,
        sortable: true,
        resizeable: true,
        width: 50
    }, {
        key: "folderSize",
        label: t_size,
        sortable: true,
        resizeable: true,
        width: 110,
        formatter: bytesFormatter
    }, {
        key: "permission",
        label: t_permissions,
        value: "Permission",
        sortable: true,
        width: 160,
        editor: permissionEditor,
        formatter: permissionFormatter
    }];

    var myPermissionData = new YAHOO.util.DataSource(
        "account.edit?action=getFolderPermissions&json=1&CSRFToken=" + csrf_token + "&OID="
        + encodeURIComponent(accountOID));
    myPermissionData.responseType = YAHOO.util.DataSource.TYPE_JSON;
    myPermissionData.connXhrMode = "ignoreStaleResponses";
    myPermissionData.connMethodPost = false;
    myPermissionData.responseSchema = {
        resultsList: "ResultSet.Result",
        fields: ["folderID", "folderName", "folderSync", "folderFiles",
            "folderSize", "permissionClass", "permission", "resourceURL", "isInvitation"]
    };
    myPermissionData.doBeforeCallback = function (oRequest, oFullResponse, oParsedResponse, oCallback) {
        permissionsLoaded = true;
        return oParsedResponse;
    };

    // Set up editing flow
    var highlightEditableCell = function (oArgs) {
        var elCell = oArgs.target;
        if (YAHOO.util.Dom.hasClass(elCell, "yui-dt-editable")) {
            this.highlightCell(elCell);
        }
    };

    accountPermissionTable = new YAHOO.widget.DataTable(
        "accountEditPermissionsListJSON", myPermissionDefs,
        myPermissionData, {
            sortedBy: {
                key: "folderName",
                dir: "asc"
            },
            MSG_EMPTY: t_empty,
            MSG_SORTASC: t_sort_asc,
            MSG_SORTDESC: t_sort_desc
        });

    accountPermissionTable.subscribe("cellMouseoverEvent",
        highlightEditableCell);
    accountPermissionTable.subscribe("cellMouseoutEvent",
        accountPermissionTable.onEventUnhighlightCell);
    accountPermissionTable.subscribe("cellClickEvent", function (oArgs) {
        if (accountPermissionTable.getRecord(oArgs.target).getData("permission") == "OWNER"
            && accountPermissionTable.getColumn(oArgs.target).key == "permission") {
            alert(msg_change_owner_permissions);
        } else {
            accountPermissionTable.showCellEditor(oArgs.target);
        }
    });

    // Behavior: Remove folder from table if set to no access.
    permissionEditor.subscribe("saveEvent", function (oArgs) {
        var newPermission = oArgs.newData;
        if (newPermission == "NO_ACCESS") {
            accountPermissionTable.deleteRowsBy(function (data) {
                return data.permission == "NO_ACCESS";
            });
        }
    });

    // Auto complete folder add field -----
    var myFolderDS = new YAHOO.util.DataSource("folder?json=1&action=getFolders&CSRFToken=" + csrf_token + "&");
    myFolderDS.responseType = YAHOO.util.DataSource.TYPE_JSON;
    myFolderDS.connXhrMode = "ignoreStaleResponses";
    myFolderDS.connMethodPost = false;
    myFolderDS.responseSchema = {
        resultsList: "ResultSet.Result",
        fields: ["name", "ID", "sync", "files", "size"]
    };
    var myAutoComp = new YAHOO.widget.AutoComplete("accountEditAddFolderInput",
        "accountEditAddFolderContainer", myFolderDS);
    myAutoComp.queryQuestionMark = false;

    var itemSelectHandler = function (sType, aArgs) {
        YAHOO.log(sType); // this is a string representing the event;
        // e.g., "itemSelectEvent"
        var oMyAcInstance = aArgs[0]; // your AutoComplete instance
        var elListItem = aArgs[1]; // the <li> element selected in the
        // suggestion
        // container
        var oData = aArgs[2]; // object literal of data for the result
        // definied by myFolderDS.responseSchema
        var folderName = oData[0];
        var folderID = oData[1];
        lastSelectedFolderSync = oData[2];
        lastSelectedFolderFiles = oData[3];
        lastSelectedFolderSize = oData[4];

        $("#accountAddFolderID").val(folderID);
        // alert(lastSelectedFolderSync + ", " + lastSelectedFolderFiles + ", "
        // + lastSelectedFolderSize);
    };
    myAutoComp.itemSelectEvent.subscribe(itemSelectHandler);
    myAutoComp.dataRequestEvent.subscribe(function () {
        // Clear Folder ID. Set on select actual folder item only.
        $("#accountAddFolderID").val("");
    });
    // Folder add auto complete end

    return {
        oDS: myPermissionData,
        oDT: accountPermissionTable
    };
}

var accountGroupTable;
var accountGroupDS;
var groupsLoaded = false;

function removeGroup(OID) {
    accountGroupTable.deleteRowsBy(function (data) {
        return data.OID == OID;
    });
}

function initAccountGroupsTable() {
    var nameFormatter = function (elCell, oRecord, oColumn, groupname) {
        elCell.innerHTML = escapeXSite(groupname);
    };

    var actionLinkFormatter = function (elCell, oRecord, oColumn, OID) {
        elCell.innerHTML = '<a href="javascript:removeGroup(\'' + OID
            + '\');" class="deletelink" title="' + t_remove_group + '">&nbsp;</a>';
    };

    var groupColumnDefs = [
        {
            key: "groupname",
            label: t_name,
            formatter: nameFormatter,
            sortable: true,
            width: 650
        }, {
            key: "OID",
            label: "",
            formatter: actionLinkFormatter,
            sortable: false,
            width: 50
        }
    ];

    accountGroupDS = new YAHOO.util.DataSource("account.edit?action=getGroupList&json=1&CSRFToken=" + csrf_token + "&OID="
        + encodeURIComponent(accountOID));
    accountGroupDS.responseType = YAHOO.util.DataSource.TYPE_JSON;
    accountGroupDS.connXhrMode = "ignoreStaleResponses";
    accountGroupDS.connMethodPost = true;
    accountGroupDS.responseSchema = {
        resultsList: "ResultSet.Result",
        fields: ["groupname", "OID"]
    };
    accountGroupDS.doBeforeCallback = function (oRequest, oFullResponse, oParsedResponse, oCallback) {
        groupsLoaded = true;
        return oParsedResponse;
    };

    accountGroupTable = new YAHOO.widget.DataTable("accountGroupListJSON",
        groupColumnDefs, accountGroupDS, {
            sortedBy: {
                key: "groupname",
                dir: "asc"
            },
            MSG_EMPTY: t_no_groups_found,
            MSG_LOADING: t_loading,
            MSG_SORTASC: t_sort_asc,
            MSG_SORTDESC: t_sort_desc,
            initialLoad: true
        }
    );

    // Auto Comp

    var autoCompDS = new YAHOO.util.DataSource("groups?action=getGroups&json=1&CSRFToken=" + csrf_token + "&accountOID="
        + accountOID + "&");
    autoCompDS.responseType = YAHOO.util.DataSource.TYPE_JSON;
    autoCompDS.connXhrMode = "ignoreStaleResponses";
    autoCompDS.connMethodPost = true;
    autoCompDS.responseSchema = {
        resultsList: "ResultSet.Result",
        fields: ["name", "ID"]
    };

    var autoComp = new YAHOO.widget.AutoComplete("accountEditGroupInput",
        "accountEditAddGroupContainer", autoCompDS);
    autoComp.queryQuestionMark = false;
    autoComp.formatResult = function (oResultData) {
        return oResultData[0];
    };

    var itemSelectHandler = function (sType, aArgs) {
        var oData = aArgs[2];
        var groupOID = oData[1];

        $('#accountAddGroupID').val(groupOID);
    };

    autoComp.itemSelectEvent.subscribe(itemSelectHandler);
    autoComp.dataRequestEvent.subscribe(function () {
        $('#accountAddGroupID').val('');
    });

    return {
        oDS: accountGroupDS,
        oDT: accountGroupTable
    };
}

// ****************************************************************************
// HOME VIEW ******************************************************************
// ****************************************************************************

var accountHomeDataSource, accountHomeTable;

function downloadCSV() {
    $.download("account.csv", "query=" + $("#accountHomeSearchInput").val() + "&CSRFToken=" + csrf_token);
}

function importCSV() {
    $('#uploadCSV').click();
}

function showAccountHome() {
    hideAccountApp();
    $('.accountHomeList').show();
    $('.mainFunctionsSearch').show();
    $('.sortContainer').show();
    $('.accountmain').show();
    $('.accountedit').hide();
    focusFirstInputField();
}

function refreshAccountHome() {
    accountHomeTable.getRecordSet().reset();
    accountHomeTable.render();
    accountHomeTable.showTableMessage(accountHomeTable.get("MSG_LOADING"),
        YAHOO.widget.DataTable.CLASS_LOADING);

    checkAccountSearchRemove();

    accountHomeDataSource.sendRequest("&query="
        + $("#accountHomeSearchInput").val(),
        accountHomeTable.onDataReturnInitializeTable, accountHomeTable);
}

function sortAccountHome() {
    sortProperty = $('#sortPropertyAccounts').val();
    sortOrder = $('#sortOrderAccounts').val();

    accountHomeDataSource.sendRequest("&sortProperty=" + sortProperty + "&sortOrder=" + sortOrder,
        accountHomeTable.onDataReturnInitializeTable, accountHomeTable);
}

function initAccountHome() {

    var myFunctionDS = new YAHOO.util.FunctionDataSource(refreshAccountHome);
    myFunctionDS.queryMatchContains = true;
    var myAutoComplete = new YAHOO.widget.AutoComplete(
        "accountHomeSearchInput", "accountHomeSearchContainer", myFunctionDS);
    myAutoComplete.minQueryLength = 0;
    myAutoComplete.applyLocalFilter = false;

    var formatUsername = function (elCell, oRecord, oColumn, displayName) {
        var inFederation = oRecord.getData("inFederation");
        nFolders = oRecord.getData("nFolders");
        var expired = oRecord.getData("OSSubscription.expired");
        var exceeded = oRecord.getData("OSSubscription.exceeded");
        if (exceeded) {
            osExceeded = "<div class='accountWarning' title='" + t_storage_exceeded + "'>" + "</div>";
        } else {
            osExceeded = "";
        }

        var oDate = oRecord.getData("OSSubscription.validTill");
        var formattedDate;
        if (oDate > 0) {
            formattedDate = t_valid_until + ": &nbsp;" + YAHOO.util.Date.format(new Date(oDate), {format: "%d %b %y"});
        } else {
            formattedDate = "";
        }
        if (expired) {
            formattedDate = "<div class='accountWarning' title='" + t_subscription_expired + "'>" + formattedDate + "</div>";
        }

        spaceUsed = oRecord.getData("spaceUsed");
        spaceUsed /= 1024;
        var suffix = "KB";
        if (spaceUsed >= 1024) {
            spaceUsed /= 1024;
            suffix = "MB";
        }
        if (spaceUsed >= 1024) {
            spaceUsed /= 1024;
            suffix = "GB";
        }
        if (spaceUsed >= 1024) {
            spaceUsed /= 1024;
            suffix = "TB";
        }
        spaceUsedFormated = spaceUsed.toFixed(2) + ' ' + suffix;
        spaceAllowed = oRecord.getData("OSSubscription.description");
        OID = oRecord.getData("OID");
        avatarURL = baseURL + '/avatars/user/' + encodeURIComponent(OID) + "?thumbnail=true" + "&_=" + new Date().getTime();
        resourceURL = "javascript:editAccount('" + OID + "');";
        var content = formatTableName(displayName, avatarURL, resourceURL);
        if (inFederation) {
            content += "<div class='storageSize'>(" + t_components_federation + ")</div>";
            content += "<div class='fileSize'>"
                + t_folders
                + ": &nbsp;"
                + nFolders
                + "</div>";
        } else {
            content +=
                "<div class='storageSize'>"
                + osExceeded
                + " &nbsp;"
                + t_space_used
                + ": &nbsp;"
                + spaceUsedFormated
                + " &nbsp;"
                + t_space_of
                + " &nbsp;"
                + spaceAllowed
                + "</div>"
                + "<div class='fileSize'>"
                + t_folders
                + ": &nbsp;"
                + nFolders
                + "</div>"

                + "<div class='expireDate'>"
                + formattedDate
                + "</div>"
                + "<div class='fileSize'>"
                + "</div>"
                + "<div class='expireDate'>"

                + "</div>";
        }
        elCell.innerHTML = content;
    };

    var formatOrgName = function (elCell, oRecord, oColumn, orgName) {
        var content = '';
        var orgCreatePermission = oRecord.getData("orgCreatePermission");
        if (orgCreatePermission === true && orgName) {
            content += '<a class="ownerlink" title="' + t_main_organization + '">&nbsp;</a>&nbsp;';
        }
        content += orgName;
        elCell.innerHTML = content;
    }

    /**
     * This is a formatting callback for YUI DataTable to present date in ISO
     * format instead of American mm/dd/yyyy
     */
    var formatDate = function (elCell, oRecord, oColumn, oData) {
        if (oData > 0) {
            var oDate = new Date(oData);
            elCell.innerHTML = YAHOO.util.Date.format(oDate, {format: "%d %b %y"});
        } else {
            elCell.innerHTML = "&nbsp;";
        }
    };

    var formatActionLink = function (elCell, oRecord, oColumn, OID) {
        var editActionHTML = '<a href="javascript:editAccount(\'' + OID + '\');" class="editlink" title="' + t_edit_account + '">&nbsp;</a>';
        var deleteActionHTML = '<a href="javascript:deleteAccount(\'' + OID + '\');"class="deletelink" title="' + t_delete_account + '">&nbsp;</a>';
        var orgCreatePermission = oRecord.getData("orgCreatePermission");

        if (loggedInAccountOID === OID || orgCreatePermission && pAdmin === false) {
            deleteActionHTML = '';
        }
        elCell.innerHTML = editActionHTML + ' &nbsp;&nbsp; ' + deleteActionHTML;
    };

    var formatFolderLink = function (elCell, oRecord, oColumn, nFolders) {
        OID = oRecord.getData("OID");
        elCell.innerHTML = "<a href=\"javascript:editAccount('" + OID
            + "', false, true);\" >" + nFolders + "</a>";
    };

    var formatOSUsed = function (elCell, oRecord, oColumn, number) {
        var exceeded = oRecord.getData("OSSubscription.exceeded");
        number /= 1024;
        var suffix = "KB";
        if (number >= 1024) {
            number /= 1024;
            suffix = "MB";
        }
        if (number >= 1024) {
            number /= 1024;
            suffix = "GB";
        }
        if (number >= 1024) {
            number /= 1024;
            suffix = "TB";
        }
        var cell = number.toFixed(2) + ' ' + suffix;
        if (exceeded) {
            cell = "<div class='accountWarning' title='" + t_storage_exceeded + "'>" + cell + "</div>";
        }
        elCell.innerHTML = cell;
    };

    var formatOSValidTill = function (elCell, oRecord, oColumn, oData) {
        var expired = oRecord.getData("OSSubscription.expired");
        var oDate = new Date(oData);
        var cell;
        if (oData > 0) {
            cell = YAHOO.util.Date.format(oDate, {format: "%d %b %y"});
        } else {
            cell = "&nbsp;";
        }
        if (expired) {
            cell = "<div class='accountWarning' title='" + t_subscription_expired + "'>" + cell + "</div>";
        }
        elCell.innerHTML = cell;
    };

    var formatComputersAllowed = function (elCell, oRecord, oColumn, computersAllowed) {
        OID = oRecord.getData("OID");
        autoRenewDevices = oRecord.getData("autoRenewDevices");
        info = computersAllowed;
        if (autoRenewDevices > 0) {
            if (autoRenewDevices == 999) {
                info = computersAllowed + "/∞";
            } else {
                info = computersAllowed + "/" + autoRenewDevices;
            }
        }
        var cell = '<a href="javascript:editAccount(\''
            + OID
            + '\');">' + info + '</a>';
        if (computersAllowed <= 0 && autoRenewDevices <= 0) {
            cell = "<div class='accountWarning' title='" + t_no_valid_licenses + "'>" + cell + "</div>";
        }
        elCell.innerHTML = cell;
    };

    var myColumnDefs = [{
        key: "displayName",
        label: t_user,
        formatter: formatUsername,
        sortable: true,
        resizeable: true,
        width: 400
    }, {
        key: "orgName",
        label: t_organization,
        formatter: formatOrgName,
        sortable: true,
        resizeable: false,
        width: 200
    }, {
        key: "lastLogin",
        label: t_last_login,
        formatter: formatDate,
        sortable: true,
        resizeable: true,
        hidden: true
    }, {
        key: "OSSubscription.description",
        label: t_space_allowed,
        sortable: true,
        resizeable: true,
        hidden: true
    }, {
        key: "spaceUsed",
        label: t_space_used,
        formatter: formatOSUsed,
        sortable: true,
        resizeable: true,
        width: 95,
        hidden: true
    }, {
        key: "OSSubscription.validTill",
        label: t_valid_until,
        formatter: formatOSValidTill,
        sortable: true,
        resizeable: true,
        width: 95,
        hidden: true
    }, {
        key: "computersAllowed",
        label: t_app_licenses,
        formatter: formatComputersAllowed,
        sortable: true,
        resizeable: true,
        width: 55,
        hidden: true
    }, {
        key: "nFolders",
        label: t_folders,
        formatter: formatFolderLink,
        resizeable: true,
        sortable: true,
        width: 55,
        hidden: true


    }, {
        key: "OID",
        label: "",
        value: "Action",
        formatter: formatActionLink
    }];

    // PFS-2061: Start
    if (orgID) {
        accountHomeDataSource = new YAHOO.util.DataSource(
            "account?json=1&action=getAccounts" + "&orgID=" + orgID + "&CSRFToken=" + csrf_token);
    } else {
        accountHomeDataSource = new YAHOO.util.DataSource(
            "account?json=1&action=getAccounts&CSRFToken=" + csrf_token);
    }
    // PFS-2061: End

    accountHomeDataSource.responseType = YAHOO.util.DataSource.TYPE_JSON;
    accountHomeDataSource.connXhrMode = "ignoreStaleResponses";
    accountHomeDataSource.connMethodPost = false;
    accountHomeDataSource.responseSchema = {
        resultsList: "ResultSet.Result",
        fields: ["username", "displayName", "lastLogin", "OSSubscription.description",
            "spaceUsed", "OSSubscription.validTill",
            "OSSubscription.expired", "OSSubscription.exceeded", "OID", "inFederation",
            "nFolders", "computersAllowed", "autoRenewDevices", "orgName", "orgCreatePermission"]
    };

    accountHomeDataSource.doBeforeCallback = function (oRequest, oFullResponse,
                                                       oParsedResponse, oCallback) {
        hideProgress();
        checkAccountHomeResults(oParsedResponse.results.length);
        return oParsedResponse;
    };

    accountHomeTable = new YAHOO.widget.DataTable("accountHomeListJSON",
        myColumnDefs, accountHomeDataSource, {
            sortedBy: {
                key: "displayName",
                dir: "asc"
            },
            MSG_EMPTY: t_no_accounts_found,
            MSG_LOADING: t_loading,
            MSG_SORTASC: t_sort_asc,
            MSG_SORTDESC: t_sort_desc,
            initialLoad: false
        });

    accountHomeTable.subscribe("initEvent",
        function () {
            initTooltip(".accountWarning");
            initTooltip(".deletelink");
            initTooltip(".editlink");
            initTooltip(".restorelink");
            initTooltip(".downloadlink");
        });

    // Buttons

    $('.accountCreate').click(function () {
        createAccount();
    });

    $('.accountDownloadCSV').click(function () {
        downloadCSV();
    });

    $('.accountImportCSV').click(function () {
        importCSV();
    });

    $('#accountSearchRemove').click(function () {
        clearAccountHomeSearchQuery();
    });

    // Sorting Dropdowns
    $('.sortContainerItem').change(function () {
        sortAccountHome();
    });

    // Automatically edit the first account in the table when pressing enter.
    $('#accountHomeSearchInput').keyup(function (e) {
        if (e.keyCode == 13) {
            // Enter
            editIfSingleAccountInHome();
        } else if (e.keyCode == 27) {
            // Esc
            clearAccountHomeSearchQuery();
        }
    });

    return {
        oDS: accountHomeDataSource,
        oDT: accountHomeTable
    };
}

function editIfSingleAccountInHome() {
    var recordSet = accountHomeTable.getRecordSet();
    if (recordSet.getLength() == 1) {
        var record = recordSet.getRecord(0);
        var OID = record.getData('OID');
        editAccount(OID);
    }
}

function clearAccountHomeSearchQuery() {
    $("#accountHomeSearchInput").val("");
    checkAccountSearchRemove();
    refreshAccountHome();
}

function checkAccountSearchRemove() {
    if ($("#accountHomeSearchInput").val().length > 0) {
        $("#accountSearchRemove").removeClass();
        $("#accountSearchRemove").addClass("accountRemoveResult");
    } else {
        $("#accountSearchRemove").removeClass();
        $("#accountSearchRemove").addClass("accountRemoveResultHide");
    }
}

function checkAccountHomeResults(length) {
    if (length >= 500) {
        logWarning(replaceParams(t_found_more_than, length, 500));
    } else {
        logInfo(replaceParams(t_results_found, length));
    }
}

function getValidLicenses() {
    $.get("license", {
        action: "getValidLicenses",
        type: "PRO"
    }, function (result) {
        hideProgress();
        if (result) {
            $("#licenseValid").html(replaceParams(t_valid_active_licenses, result.nValidLicenses));
            $('select[name=licenseContent]').html("");
            $('select[name=licenseContent]').append('<option>- Unused/Available licenses -</option>');
            $('select[name=licenseContent]').append('<option>- ' + t_unused_licenses + ' -</option>');

            for (var i = 0; i < result.unused.length; i++) {
                var license = result.unused[i];
                $('select[name=licenseContent]').append('<option value="' + license.contents + '">' + license.info + '</option>');
            }
            if (result.used.length > 0) {
                $('select[name=licenseContent]').append('<option>- ' + t_used_licenses + ' -</option>');
                for (i = 0; i < result.used.length; i++) {
                    license = result.used[i];
                    $('select[name=licenseContent]').append('<option value="' + license.contents + '">' + license.info + '</option>');
                }
            }
        } else {
            $("#licenseValid").html("");
        }
    });
}

// ****************************************************************************
// Organization auto complete *************************************************
// ****************************************************************************

function initOrgAutoComplete() {
  var orgDS = new YAHOO.util.DataSource("../wapi/organizations?json=1&CSRFToken=" + csrf_token + "&action=getOrganizations&");
  orgDS.responseType = YAHOO.util.DataSource.TYPE_JSON;
  orgDS.connXhrMode = "ignoreStaleResponses";
  orgDS.connMethodPost = false;
  orgDS.responseSchema = {
    resultsList : "ResultSet.Result",
      fields: ["name", "ID", "storageSize", "storageAssigned"]
  };

    var orgAutoComp = new YAHOO.widget.AutoComplete("organizationInput",
        "accountOrgContainer", orgDS);
    orgAutoComp.queryQuestionMark = false;
    orgAutoComp.formatResult = function (oResultData) {
        return escapeXSite(oResultData[0]);
    };

    var itemSelectHandler = function (sType, aArgs) {
        var oData = aArgs[2];
        var orgOID = oData[1];

      orgStorageSize = oData[2];
      orgStorageAssigned = oData[3];

        $('#organizationOID').val(orgOID);
    };

  orgAutoComp.itemSelectEvent.subscribe(itemSelectHandler);
  orgAutoComp.dataRequestEvent.subscribe(function() {
      orgStorageSize = 0;
      orgStorageAssigned = 0;
    $('#organizationOID').val("");
  });
}

// ****************************************************************************
// HELPERS ********************************************************************
// ****************************************************************************

function containedInPermissionsTable(folderID) {
    var recordSet = accountPermissionTable.getRecordSet();
    for (var i = 0; i < recordSet.getLength(); i++) {
        var record = recordSet.getRecord(i);
        var folderIDCandidate = record.getData('folderID');
        if (folderIDCandidate == folderID) {
            return true;
        }
    }
    return false;
}

function containedInGroupTable(groupID) {
    var recordSet = accountGroupTable.getRecordSet();
    for (var i = 0; i < recordSet.getLength(); i++) {
        var record = recordSet.getRecord(i);
        var groupIDCandidate = record.getData('OID');
        if (groupIDCandidate == groupID) {
            return true;
        }
    }
    return false;
}

function createUUID() {
    // http://www.ietf.org/rfc/rfc4122.txt
    var s = [];
    var hexDigits = "0123456789ABCDEF";
    for (var i = 0; i < 32; i++) {
        s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
    }
    s[12] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
    s[16] = hexDigits.substr((s[16] & 0x3) | 0x8, 1);  // bits 6-7 of the
    // clock_seq_hi_and_reserved
    // to 01

    var uuid = s.join("");
    return uuid;
}

/**
 * Source:
 * http://www.filamentgroup.com/lab/jquery_plugin_for_requesting_ajax_like_file_downloads/
 */

jQuery.download = function (url, data, method) {
    // url and data options required
    if (url && data) {
        // data can be string of parameters or array/object
        data = typeof data == 'string' ? data : jQuery.param(data);
        // split params into form inputs
        var inputs = '';
        jQuery.each(data.split('&'), function () {
            var pair = this.split('=');
            inputs += '<input type="hidden" name="' + pair[0] + '" value="'
                + pair[1] + '" />';
        });
        // send request
        jQuery(
            '<form action="' + url + '" method="' + (method || 'post')
            + '">' + inputs + '</form>').appendTo('body').submit()
            .remove();
    }
};
