// API ************************************************************************

// TODOs:
// * Rename DIVs to general naming pattern
// * Define and implement functionality

function showDashboardApp() {
	setActiveApp("dashboard");
	autoRefreshLog();
	// Show my (starting) elements
	initDashboardApp();
}

function hideDashboardApp() {
	// Hide ALL my elements
	$('.statstest').show();
	$('.dashdetails').show();
}

// API END ********************************************************************

function initDashboardApp() {
	hideDashboardApp();

	// Hack for Flash elements being on top of overlays
	$(".create").click(function() {
		hideAllCharts();
	});
	$("#create").click(function() {
		hideAllCharts();
	});
	$(".close").click(function() {
		setTimeout("initDashSpacePie()", 0);
	});

	// setTimeout("initDashSpacePie()", 0);

	$('.statstest').show();
	$('.dashdetails').show();

	focusFirstInputField();
}

function hideAllCharts() {
	$(".dashboardChart").hide();
}

function initUserRegistered() {
	hideAllCharts();
	
    var chart = $("#dashboardChartLicenseUsers");
    var colors = $.map([1.0,0.5,0.3,0.1], function (alpha) {
        return "#" + changeAlpha($("input[name=colorSelectorText]").val(), alpha) });
    for (var i = 0; i < 4; i++)
        chart.find(".color"+i).css("background", colors[i]);
    var usageData = JSON.parse(chart.attr('data-chart'));
    var myData = [
    		  {
                  value : usageData.registeredUser,
                  color : colors[0]
              },
              {
                  value : (usageData.allowedUser - usageData.registeredUser),
                  color : colors[3]
              }
            
    ]
    myData = $.grep(myData, function(e) { return e.value != null });
    var ctx = chart.find("canvas").get(0).getContext("2d");
    new Chart(ctx).Pie(myData);


    $("#dashboardChartLicenseUsers").show();
}

function initDashSpacePie() {
	hideAllCharts();
    var chart = $("#dashboardChartUsage");
    var colors = $.map([1.0,0.5,0.3,0.1], function (alpha) {
        return "#" + changeAlpha($("input[name=colorSelectorText]").val(), alpha) });
    for (var i = 0; i < 4; i++)
        chart.find(".color"+i).css("background", colors[i]);
    var usageData = JSON.parse(chart.attr('data-chart'));
    var myData = [
              {
                  value : usageData.raw.used,
                  color : colors[0]
              },
              {
             	value : usageData.raw.other,
                  color : colors[2]
              },
              {
                  value : usageData.raw.available,
                  color : colors[3]
              }
    ]
    myData = $.grep(myData, function(e) { return e.value != null });
    var ctx = chart.find("canvas").get(0).getContext("2d");
    new Chart(ctx).Pie(myData);

    $("#dashboardChartUsage").show();
}

function initDashNewUsers() {
	hideAllCharts();
    initBarChart($("#dashboardChartNewUsers"));
	$("#dashboardChartNewUsers").show();
}

function initBarChart(chart) {
    var usageData = JSON.parse(chart.attr('data-chart'));
    var colors = $.map([1.0,0.5,0.3,0.1], function (alpha) {
        return "#" + changeAlpha($("input[name=colorSelectorText]").val(), alpha) });
	var myData = {
			labels : $.map(usageData.labels, function (n, i) { return (i-1) % 5 == 0 ? n : ""}),
			datasets : [{
				fillColor : colors[0],
				strokeColor : colors[0],
				data : $.map(usageData.values, function (v) {return v.all} )
			},
			/*
			{
				fillColor : colors[1],
				strokeColor : colors[1],
				data : $.map(usageData.values, function (v) {return v.customers} )
			},
			{
				fillColor : colors[2],
				strokeColor : colors[2],
				data : $.map(usageData.values, function (v) {return v.trials} )
			} */
			]
	}
    var ctx = chart.find("canvas").get(0).getContext("2d");
    // always use a minimum scale width of 5
    var maxValue = 5;
    for (var i = 0; i < myData.datasets[0].data.length; i++) {
    	if (maxValue < myData.datasets[0].data[i])
    		maxValue = myData.datasets[0].data[i];
    }
    var scaleStepWidth = Math.pow(10, Math.floor(Math.log(maxValue)/Math.LN10));
    var scaleSteps = Math.ceil(maxValue/scaleStepWidth);
    if (scaleSteps < 5) {
    	scaleStepWidth = scaleStepWidth / 2;
        scaleSteps = Math.ceil(maxValue/scaleStepWidth);
    }
    var scaleWidth = scaleSteps * scaleStepWidth;
    new Chart(ctx).Bar(myData, {
    	scaleOverride: true,
    	scaleSteps : scaleSteps,
    	scaleStepWidth : scaleStepWidth,
    	scaleStartValue : 0,
    	//Number - Pixel width of the scale line	
    	scaleLineWidth : 2,
    	//Boolean - Whether to show labels on the scale	
    	scaleShowLabels : true,
    	//String - Scale label font declaration for the scale label
    	scaleFontFamily : "'Arial'",
    	//Number - Scale label font size in pixels	
    	scaleFontSize : 12,
    	//String - Scale label font weight style	
    	scaleFontStyle : "normal",
    	//String - Scale label font colour	
    	scaleFontColor : "#444",	
    	///Boolean - Whether grid lines are shown across the chart
    	scaleShowGridLines : true,
    	//Number - Spacing between each of the X value sets
    	barValueSpacing : 2,
    });
}

function initDashLastLogins() {

	hideAllCharts();
	
	initBarChart($("#dashboardChartLastLogins"));

	$("#dashboardChartLastLogins").show();
}

// Helper code ----------------------------------------------------------------

var refreshTimer;

function refreshLog() {
	var nLines = 1000;
	$('.mainErrorDisplay').load('logdashboard',
		"action=refresh&nLines=" + nLines + "&level=SEVERE&ajax=true&CSRFToken=" + csrf_token
	);
}

function autoRefreshLog() {
	refreshLog();
	window.setInterval("refreshLog()", 5000);
}

function hex(c) {
	var s = "0123456789abcdef";
	var i = parseInt(c);
	if (i == 0 || isNaN(c))
		return "00";
	i = Math.round(Math.min(Math.max(0, i), 255));
	return s.charAt((i - i % 16) / 16) + s.charAt(i % 16);
}

/* Convert an RGB triplet to a hex string */
function convertToHex(rgb) {
	return hex(rgb[0]) + hex(rgb[1]) + hex(rgb[2]);
}

/* Remove '#' in color hex string */
function trim(s) {
	return (s.charAt(0) == '#') ? s.substring(1, 7) : s
}

/* Convert a hex string to an RGB triplet */
function convertToRGB(hex) {
	var color = [];
	color[0] = parseInt((trim(hex)).substring(0, 2), 16);
	color[1] = parseInt((trim(hex)).substring(2, 4), 16);
	color[2] = parseInt((trim(hex)).substring(4, 6), 16);
	return color;
}

function changeAlpha(colorHex, alpha) {
	var start = convertToRGB(colorHex);
	var end = convertToRGB($("input[name=colorSelectorBack]").val());
	var c = [];
	c[0] = start[0] * alpha + (1 - alpha) * end[0];
	c[1] = start[1] * alpha + (1 - alpha) * end[1];
	c[2] = start[2] * alpha + (1 - alpha) * end[2];
	return convertToHex(c);
}
