// ****************************************************************************
// API ************************************************************************
// ****************************************************************************

function showProductApp() {
	setActiveApp("products");
	// Show my (starting) elements
	hideProductApp();
	initProductApp(true);
	showProductHome();
}

function hideProductApp() {
	// Hide ALL my elements
	$('.productHomeList').hide();
	$('.productEditMenu').hide();
	$('.productEditor').hide();
}

// ****************************************************************************
// EDITOR *********************************************************************
// ****************************************************************************




var productOID;

function createProduct() {
	editProduct(createUUID(), true);
}

function editProduct(OID) {
	editProduct(OID, false);
}

function editProduct(OID, newObject) {
	productOID = OID;
	initProductEditor(newObject);
}

function deleteProduct(OID) {
	if (confirm("Are you sure to delete this product?\n\n" +
			"WARNING: Existing subscriptions of this\n" +
			"product won't longer work!\n ")) {
		// Delete product
		$.get("product.edit", {
			action : "delete",
			OID : OID,
			CSRFToken : csrf_token
		}, function() {
			// Reload HOME list
			refreshProductHome();
			showProductHome();
		});
	}
}

function cancelProduct() {
	hideProductApp();
	// Reload HOME list
	refreshProductHome();
	showProductHome();
}

function saveProduct() {
	var formValid = $("#productEditorForm").validate().form();
	if (formValid) {
		$('#productEditorForm').ajaxSubmit(productEditorFormOptions);
	}
}

var productEditorFormOptions = {
	success : function(responseText, textStatus) {
	   refreshProductHome();
        showProductHome();
	},
	error : function(XMLHttpRequest) {
		logError(XMLHttpRequest.statusText);
	}
};

function showProductEditor() {
	$('.productHomeList').hide();
	$('.productEditor').show();
	$('.productEditMenu').show();
	focusFirstInputField();
}

function initProductApp(refreshHome) {
	hideProductApp();

	// Form.
	$('#productEditor').submit(function() {
		saveProduct();
		return false;
	});

	// Buttons
	$('.productEditSave').click(function() {
		saveProduct();
	});

	$('.productEditDelete').click(function() {
		deleteProduct(productOID);
	});

	$('.productEditCancel').click(function() {
		cancelProduct();
	});

	initProductHome();
	if (refreshHome) {
		refreshProductHome();
	}
}

function initProductEditor(newObject) {
	$('#productEditor').load("product.edit", {
		action : "getEditor",
		newObject : newObject ? "true" : "false",
		OID : productOID,
		CSRFToken : csrf_token
	}, function() {
		// Initialize validation
			$('#productEditorForm').validate( {
				submitHandler : function(form) {
					saveProduct();
				}
			});

			// Create new product if necessary
			$("#productEditorForm input[name=newObject]").val(newObject);

			showProductEditor();

			$('#productEditorForm input[name=articleNo]').keyup(function(e) {
				if (e.keyCode == 13) {
					// Enter Do nothing
				} else if (e.keyCode == 27) {
					// Esc
					cancelProduct();
				}
			});
			
			// Menu bar
			$('.productCreate').hide();
			$('.productEditSave').show();
			$('.productEditCancel').show();
		});
}

// ****************************************************************************
// HOME VIEW ******************************************************************
// ****************************************************************************

var productHomeDataSource, productHomeTable;

function showProductHome() {
	hideProductApp();
	$('.productHomeList').show();
	
	// Menu bar
	$('.productCreate').show();
	$('.productEditSave').hide();
	$('.productEditCancel').hide();
}

function refreshProductHome() {
	productHomeTable.getRecordSet().reset();
	productHomeTable.render();
	productHomeTable.showTableMessage(productHomeTable.get("MSG_LOADING"),
			YAHOO.widget.DataTable.CLASS_LOADING);
	productHomeDataSource.sendRequest("",
			productHomeTable.onDataReturnInitializeTable, productHomeTable);
}

function initProductHome() {

	/**
	 * This is a formatting callback for YUI DataTable to present date in ISO
	 * format instead of American mm/dd/yyyy
	 */
	var formatOSSize = function(elCell, oRecord, oColumn, oData) {
		var osSize = oData / 1024;
		var suffix = "KB";

		if (osSize >= 1024) {
			osSize = osSize / 1024;
			suffix = "MB";
		}
		if (osSize >= 1024) {
			osSize = osSize / 1024;
			suffix = "GB";
		}
		if (osSize >= 1024) {
			osSize = osSize / 1024;
			suffix = "TB";
		}
		osSize = Math.round(osSize * 100);
		osSize = osSize / 100;
		elCell.innerHTML = osSize + " " + suffix;
	};

	var formatVisibility = function(elCell, oRecord, oColumn, visible) {
		if (visible) {
			elCell.innerHTML = '<img src="images/tick.gif" />';
		} else {
			elCell.innerHTML = '<img src="images/cross.gif" />';
		}
	};

	var formatActionLink = function(elCell, oRecord, oColumn, OID) {
		elCell.innerHTML = '<a href="javascript:editProduct(\''
				+ OID
				+ '\');"class="editlink" title="' + t_edit_product + '">&nbsp;</a>&nbsp;&nbsp;&nbsp;<a href="javascript:deleteProduct(\''
				+ OID + '\');" class="deletelink" title="' + t_delete_product + '">&nbsp;</a>';
	};

	var myColumnDefs = [ {
		key : "articleNo",
		label : t_article_no,
		sortable : true
	}, {
		key : "name",
		label : t_name,
		sortable : true,
		width : 240
	}, {
		key : "OSSize",
		label : t_storage,
		sortable : true,
		formatter : formatOSSize,
		width : 70
	}, {
		key : "proLicenses",
		label : t_license_no_of_computers,
		sortable : true,
		width : 70
	}, {
		key : "price1M",
		label : t_price_per_month,
		sortable : true,
		width : 70
	}, {
		key : "price12M",
		label : t_price_per_year,
		sortable : true,
		width : 70
	}, {
		key : "currencyCode",
		label : t_currency,
		sortable : true,
		width : 70
	}, {
		key : "visible",
		label : t_visible,
		sortable : true,
		formatter : formatVisibility
	}, {
		key : "OID",
		label : "",
		value : "Action",
		formatter : formatActionLink
	} ];

	productHomeDataSource = new YAHOO.util.DataSource(
			"product?action=getHomeList&CSRFToken=" + csrf_token);
	productHomeDataSource.responseType = YAHOO.util.DataSource.TYPE_JSON;
	productHomeDataSource.connXhrMode = "ignoreStaleResponses";
	productHomeDataSource.connMethodPost = false;
	productHomeDataSource.responseSchema = {
		resultsList : "ResultSet.Result",
		fields : [ "articleNo", "visible", "name", "OSSize", "price1M",
				"price12M", "currencyCode", "proLicenses", "OID" ]
	};

	productHomeTable = new YAHOO.widget.DataTable("productHomeListJSON",
			myColumnDefs, productHomeDataSource, {
				sortedBy : {
					key : "articleNo",
					dir : "asc"
				},
				MSG_EMPTY : t_no_products_found,
				MSG_LOADING : t_loading,
			    MSG_SORTASC : t_sort_asc,
			    MSG_SORTDESC : t_sort_desc,
				initialLoad : false
			});

	// Buttons

	$('.productCreate').click(function() {
		createProduct();
	});

	return {
		oDS : productHomeDataSource,
		oDT : productHomeTable
	};
}

function createUUID() {
    // http://www.ietf.org/rfc/rfc4122.txt
    var s = [];
    var hexDigits = "0123456789ABCDEF";
    for (var i = 0; i < 32; i++) {
        s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
    }
    s[12] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
    s[16] = hexDigits.substr((s[16] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01

    var uuid = s.join("");
    return uuid;
}