/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

if (!window.Picasso.hasOwnProperty("Dialog")) {
    window.Picasso.Dialog = {};
}

/* Private scope */
(function () {

    /**
     * Constructor for {@link Picasso.Dialog.Invitation}
     *
     * @param  head  Head message
     * @param  body  Body message
     * @constructor
     **/

    Picasso.Dialog.Invitation = function (head, body) {

        /* Sanity check */
        this._dialog = $("#pica_invitation_dialog");

        if (0 === this._dialog.length) {
            throw "Dialog not found";
        }

        /* Init */
        this.invitation = null;

        /* Update dialog */
        this._dialog.find(".modal-title").text(head);
        this._dialog.find(".modal-body h5").text(body);

        /* Re-bind handler */
        this._dialog.find("#invitation_accept").off("click").click($.proxy(function () {

            var invitation = this.invitation;
            var cwd = Picasso.get("cwd");

            /* Accept invitation */
            if (invitation) {
                invitation.accept(

                    /* Success */
                    function () {
                        Picasso.Notification.show(Picasso.Lang.get(
                            "notification_invitation_accepted"), "info");

                        Picasso.Files.fetch(cwd);
                    },

                    /* Error */
                    function (e) {
                        Picasso.debugLog(e);
                    }
                )
            }
        }, this));

        this._dialog.find("#invitation_decline").off("click").click($.proxy(function () {

            var invitation = this.invitation;
            var cwd = Picasso.get("cwd");

            /* Decline invitation */
            if (invitation) {
                invitation.decline(

                    /* Success */
                    function () {
                        Picasso.Notification.show(Picasso.Lang.get(
                            "notification_invitation_declined"), "info");

                        Picasso.Files.fetch(cwd);
                    },

                    /* Error */
                    function (e) {
                        Picasso.debugLog(e);
                    }
                )
            }
        }, this));
    };

    /**
     * Set invitation for this dialog
     *
     * @param {Object}  invitation The invitation object.
     **/

    Picasso.Dialog.Invitation.prototype.setInvitation = function (invitation) {

        this.invitation = invitation;
    };

    /**
     * Show invitation dialog
     **/

    Picasso.Dialog.Invitation.prototype.show = function () {

        this._dialog.modal();
    };
})();