/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {

    /* Bind handlers */
    $("#register_form").on("submit", function (e) {

        /* Check validation result */
        if (!Picasso.Helper.validateInputs(this)) {
            e.preventDefault();
            e.stopPropagation();
            return;
        }
    });

    /* Add handler for password policy */
    var input = $("#register_password");

    /* Add change handler to update policy info */
    input.on("keyup", function (e) {
        Picasso.Helper.checkRegistrationPolicy(this,
                e.originalEvent.target.value);
    });

    /* Add click handler to clear button to update policy as well */
    input.siblings(".pica-input-clear").click(function () {
        Picasso.Helper.checkRegistrationPolicy(input);
    });

})();
