/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {

    /* Globals */
    Picasso.VARS = {
        debug: true,
        baseUrl: null,
        CSRF: null
    };

    /**
     * Set key to given value
     *
     * @param {String}  key    Name of the variable
     * @param {Object}  value  New value
     **/

    Picasso.set = function (key, value) {
        Picasso.debugLog("set: " + key + "=" + value);

        Picasso.VARS[key] = value;
    };

    /**
     * Unset variable given by key
     *
     * @param {String}  key  Name of the variable
     **/

    Picasso.unset = function (key) {
        Picasso.debugLog("unset:" + key);

        delete Picasso.VARS[key];
    };

    /**
     * Get value of given variable
     *
     * @param {String}  key  Name of the variable
     *
     * @returns {Object} Either property when found; otherwise null
     **/

    Picasso.get = function (key) {
        if (Picasso.VARS.hasOwnProperty(key)) {
            return Picasso.VARS[key];
        } else {
            return null;
        }
    };

    /**
     * Check whether key exists
     *
     * @param {String}  key  Name of the variable
     *
     * @returns {Boolean} Either true when found; otherwise false
     **/

    Picasso.hasKey = function (key) {
        return Picasso.VARS.hasOwnProperty(key);
    };

    /**
     * Show debugging messages
     *
     * @param {String}  text  Output text
     **/

    Picasso.debugLog = function (text) {
        if (true === Picasso.VARS.debug) {
            console.log(text);
        }
    };

    /* Avatar handling */
    $(".pica-avatar").each(function () {
        var that = $(this);

        if (0 < that.siblings().length) {
            that.on("load", function () {
                that.siblings(".glyphicons").hide();
                that.show();
            });

            that.on("error", function () {
                that.siblings(".glyphicons").show();
                that.hide();
            });

            /* Force reload to avoid cases when image was loaded before
               handler has been assigned */
            that.attr("src", that.attr("src"));
        }
    });

    /* Update input type when text-security isn't supported */
    $(".pica-password").each(function () {
        var that = $(this);

        var style = window.getComputedStyle(that[0]);

        if (style && !style.webkitTextSecurity) {
            that[0].setAttribute("type", "password");
        }
    });

    /* Init after page load */
    $(document).ready(function () {

        /* Init tooltips */
        $("[data-tooltip]").tooltip({ container: "body" });

        /* Init input clear buttons */
        $(".pica-input-clear").click(function () {
            var input = $(this).closest(".form-group").find("input");
            if (input.prop("readonly") && input.hasClass("mfa")) {
                window.location.href = "/logout";
            } else if (!input.prop("disabled")) {
                input.val("");
            }
        });

        $(".pica-password-toggle").click(function () {
            $(this).find('i').toggleClass("glyphicon-eye-close");
            var input = $($(this).attr("toggle"));
            if (input.attr("type") == "password") {
                input.attr("type", "text");
            } else {
                input.attr("type", "password");
            }
        });

        $(".pica-input-copy").click(function () {
            let temp = $("<input>");
            $("body").append(temp);
            temp.val($(this).closest(".form-group").find("input:disabled").val());
            Picasso.Helper.copyToClipboard($(temp));
            temp.remove();
        });

        /* Init button checkboxes */
        $(".pica-button-checkbox").each(Picasso.Helper.createButtonCheckbox);

        /* Mark current page */
        var current = $("#pica_menu a").filter(function () {
            return -1 !== $(this).prop("href").indexOf(location.pathname);
        });

        current.addClass("active");
    });
})();
