/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {


    /**
     * Constructor for {@link Picasso.Customer}
     *
     * @constructor
     **/

    Picasso.Customer = function (data) {
        var json = Picasso.Helper.tryJSON(data);

        /* Fetch data: Load from server or restore from stringified object  */
        this._id = Picasso.Helper.getPropOrDefValue(json, null, "id", "_id");
        this._accountOID = Picasso.Helper.getPropOrDefValue(json, null, "accountOID", "_accountOID");
        this._email = Picasso.Helper.getPropOrDefValue(json, null, "email", "_email");
        this._name = Picasso.Helper.getPropOrDefValue(json, null, "name", "_name");
        this._currency = Picasso.Helper.getPropOrDefValue(json, null, "currency", "_currency");
        this._vatId = Picasso.Helper.getPropOrDefValue(json, null, "vatId", "_vatId");
        this._phone = Picasso.Helper.getPropOrDefValue(json, null, "phone", "_phone");
        this._addressLine1 = Picasso.Helper.getPropOrDefValue(json, null, "addressLine1", "_addressLine1");
        this._addressLine2 = Picasso.Helper.getPropOrDefValue(json, null, "addressLine2", "_addressLine2");
        this._addressPostalCode = Picasso.Helper.getPropOrDefValue(json, null, "addressPostalCode", "_addressPostalCode");
        this._addressCity = Picasso.Helper.getPropOrDefValue(json, null, "addressCity", "_addressCity");
        this._addressCountry = Picasso.Helper.getPropOrDefValue(json, null, "addressCountry", "_addressCountry");

        /* Create proxy to catch getter/setter calls */
        return Picasso.Helper.createProxy(this);
    };


    /**
     * Get strip customer for {@link Picasso.Account}
     *
     * @param {Function}  onSuccess  Call on success
     * @param {Function}  onError    Call on error
     **/

    Picasso.Customer.getCustomer = function (accountOID, onSuccess, onError) {
        if ("" === accountOID) return;

        var url = "/wapi/customers";
        var data = {
            action: "getCustomer",
            accountOID: accountOID
        };

        /* Fire ajax call */
        return Picasso.Helper.fireAjax(url, data,

            /* Success */
            function (json) {
                var ary = Picasso.Helper.getResultArray(json);
                if (onSuccess) onSuccess(ary[0]);
            }, onError
        );
    };


    /**
     * create or update strip customer for {@link Picasso.Account}
     *
     * @param {Function}  onSuccess  Call on success
     * @param {Function}  onError    Call on error
     **/

    Picasso.Customer.prototype.setCustomer = function (onSuccess, onError) {


        if ("" === this.getAccountOID()) return;

        var url = "/wapi/customers";
        var data = {
            action: "storeCustomer",
            method: "POST",
            id: this.getId(),
            accountOID: this.getAccountOID(),
            email: this.getEmail(),
            phone: this.getPhone(),
            name: this.getName(),
            addressLine1: this.getAddressLine1(),
            addressLine2: this.getAddressLine2(),
            addressPostalCode: this.getAddressPostalCode(),
            addressCity: this.getAddressCity(),
            addressCountry: this.getAddressCountry(),
            currency: this.getCurrency(),
            vatId: this.getVatId()
        };

        /* Fire ajax call */
        return Picasso.Helper.fireAjax(url, data,

            /* Success */
            function (json,status) {
                var ary = Picasso.Helper.getResultArray(json);

                if (onSuccess) onSuccess(ary,status);
            }, function (xhr,status){
                if (onError) onError(xhr,status)
            }
        );
    };

})();
