/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

if (!window.Picasso.hasOwnProperty("Notification")) {
    window.Picasso.Notification = {};
}

/* Private scope */
(function () {

    /**
     * Update bagdes and list
     *
     * @param {String}  message   Message to add
     * @param {String}  iconName  Message icon
     **/

    var update = function (message, iconName) {
        var badge = $("#pica_notifications .badge");

        if (0 !== badge.length) {
            badge.text(parseInt(badge.text()) + 1);

            var li = $("<li>");

            if (iconName) li.append(Picasso.Helper.createGlyph(iconName));

            li.append(Picasso.Helper.encodeHTMLEntities(message));

            $("#pica_notifications ul").prepend(li);
        }
    };

    /**
     * Restack all notifications
     **/

    var restack = function () {
        var notifications = $(".pica-notification").get().reverse();

        if (0 < notifications.length) {
            for (var i = 0; i < notifications.length; i++) {
                var n = $(notifications[i]);

                n.css("bottom", (10 + (i * (n.outerHeight(true) + 10))) + "px");
            }
        }
    };

    /**
     * Show new notification
     *
     * @param {String}   message       Message to show
     * @param {String}   type          Message type (optional)
     * @param {Boolean}  noAutoClose   Whether to keep message (optional)
     **/

    Picasso.Notification.show = function (message, type, noAutoClose, icon) {
        /* Generate id and check for duplicates */
        var id = "notification_" + Picasso.Helper.hashCode(message);
        var elem = $("#" + id);

        if (0 < elem.length) {
            var box = elem.find(".pica-notification-box");
            var badge = box.find(".badge");

            /* Either increase badge or otherwise create a new one */
            if (0 !== badge.length) {
                badge.text(parseInt(badge.text()) + 1);
            } else {
                box.append($("<span>", {
                    class: "badge btn-" + (type ? type : "danger"),
                    text: 2
                }));
            }

            return;
        }

        /* Create and append notification */
        var div = $("<div>", {
            id: id,
            class: "pica-notification"
        });

        var box = $("<div>", {
            class: "pica-notification-box alert alert-" + (type ? type : "danger"),
            role: "alert"
        });

        /* Add given icon or otherwise defaults  */
        var glyph;

        icon = icon ? icon : type;

        switch (icon) {
            case "ok":
                glyph = "ok-sign";
                break;
            case "remove":
                glyph = "remove-sign";
                break;

            case "question":
                glyph = "question-sign";
                break;

            case "danger":
                /* Falls through */
            case "exclamation":
                glyph = "exclamation-sign";
                break;

            case "info":
                /* Falls through */
            default:
                glyph = "info-sign";
                break;
        }

        box.append(Picasso.Helper.createGlyph(glyph));

        box.append($("<span>", {
            text: Picasso.Helper.capitalize(message)
        }));

        /* Add button */
        var button = $("<button>", {
            type: "button",
            class: "close",
            html: "&times;",
            "data-dismiss": "alert",
            "aria-hidden": false
        });

        box.append(button);
        div.append(box);

        $("body").append(div);

        /* Update badge and list and restack */
        update(message, glyph);
        restack();

        /* Hide notification after some seconds (5s for success/info, 10s for warning/danger) */
        if (true !== noAutoClose) {
            var delay = (type === "warning" || type === "danger") ? 10000 : 5000;
            div.delay(delay).hide("slow", function () {
                div.remove();

                restack();
            });
        }
    };

    /**
    *
    * Show Login notification message
    *
    * if message is not empty.
    * if user didn't click on hide
    * if the message changed

    * */
    Picasso.Notification.displayLoginMessage = function (messageKey) {

        var messageViewed = localStorage.getItem(messageKey);
        var dialog = new Picasso.Dialog("#pica_message_dialog");

        Picasso.Helper.getPopupMessage(messageKey, function (newMessage) {

                    dialog.setOkHandler(function () {
                        localStorage.setItem(messageKey, newMessage);
                    })

                    if ((messageViewed == null && newMessage != "" || messageViewed !== newMessage && newMessage != "") && newMessage.replace(/<p>&nbsp;<\/p>/gm, '').trim() != "") {
                        dialog.show();
                    }

                }, function () {
                }
        );
    }
})();
