/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {

    var baseurl = window.location.protocol + "//" + window.location.host + "/";

    $(document).ready(function () {

        function adjustLayout() {
            const navbarHeight = $(".navbar-fixed-top").height();
            const searchHeight = $("#pica_action_search").height();
            const linkTop = navbarHeight + searchHeight * 2;

            /*if (navbarHeight > 100) {*/
                $("body").css("padding-top", navbarHeight + searchHeight);
                $(".pica_link").css("top", linkTop);
/*
            }
*/
        }

        $(window).on('resize', adjustLayout);

        screen.orientation.addEventListener("change", adjustLayout);

    })


    /**
     * Handle click on upload button
     **/

    var handleClickUpload = function () {
        var upload = new Picasso.Dialog.Upload(Picasso.Lang.get("dialog_title_upload"),
            Picasso.Lang.get("dialog_body_upload",
                Picasso.Lang.get(Picasso.Lang.Flags.DOWNCASE, "label_links")));

        /* Append token if any */
        var fileLinkToken = $("#fileLikeToken").val();
        var cwd = Picasso.get("cwd");
        if (cwd){
            upload.setData({
                folderID: cwd.getFolderId(),
                path: cwd.getPath(),
                fileLinkToken: fileLinkToken,
                fileLinkId: $("#fileLinkId").val()
            });
        }
        upload.setDoneHandler(function () {
                Picasso.Files.fetch(cwd);
            }
        );

        upload.setUrl("/ul/" + $("#fileLinkId").val());


        upload.show();
    };

    /**
     * Handle click on QR button
     **/

    var handleClickQr = function () {

        var dialog = new Picasso.Dialog("#pica_canvas_dialog",
            Picasso.Lang.get("dialog_title_link",$("#fileLikeName").val()));

        dialog.setAssignHandler(function () {
            var canvas = document.getElementById("board")
            var qrcode = new QRious({
                element: canvas,
                background: '#ffffff',
                backgroundAlpha: 1,
                foreground: '#000000',
                foregroundAlpha: 1,
                level: 'H',
                padding: 0,
                size: 300,
                value: baseurl+"getlink/"+$("#fileLinkId").val()
            });

        });

        dialog.show()
    };

    /**
     * Handle click on download button
     *
     * @param {Event}  e  Click event
     **/

    var handleClickDownload = function (e) {
        e.preventDefault();
        e.stopPropagation();

        var fileLinkToken = $("#fileLikeToken").val();
        var url = $(this).attr("href");

        if (0 < fileLinkToken.length) {
            if (-1 === url.indexOf("?")) {
                url += "?fileLinkToken=" + fileLinkToken;
            } else {
                url += "&fileLinkToken=" + fileLinkToken;
            }
        }

        window.location.assign(url);
    };

    /**
     * Handle click on copy button
     *
     * @param {Event}  e  Click event
     **/

    var handleClickCopyToClip = function (e) {
        var that = $(this);

        Picasso.Helper.copyToClipboard.apply(that, that.parent().children("input"));
    };

    var handleClickSettings = function () {
            var fileLinkId = document.getElementById('fileLinkId').value;

            Picasso.Link.getLink(fileLinkId, function (link, status) {
                switch (status) {
                    case 200:
                        var linkDialog = new Picasso.Dialog.Link();
                        linkDialog.edit(link, function () {
                            console.log('Link edited successfully.');
                            location.reload();
                        }, function (error) {
                            console.error('Error editing link:', error);
                        });
                        break;
                    default:
                        console.error('Unexpected status code:', status);
                        break;
                }
            }, function (error) {
                console.error('Error getting link details:', error);
            });
    }

    /* Bind handlers */
    $("#filelink_copy").click(handleClickCopyToClip);
    $("#filelink_download").click(handleClickDownload);
    $("#filelink_upload").click(handleClickUpload);
    $("#filelink_qr").click(handleClickQr);
    $("#link_settings").click(handleClickSettings);

    /* Sanitize url */
    var input = $('input[type="text"]');

    input.val(Picasso.Helper.sanitizeUrl(input.val()));
})();
