(function() {
    try {
        const params = new URLSearchParams(window.location.search);
        const orderedTracking = [];   // maintain order explicitly
        const trackingData = {};      // final object for storage

        // Preserve UTM parameter order exactly as in the URL
        for (const [key, value] of params.entries()) {
            if ((key.startsWith('utm_') || key === 'gclid') && value) {
                orderedTracking.push([key, value]);
            }
        }

        // Capture referrer last (not from URL)
        if (document.referrer && !document.referrer.includes(window.location.hostname)) {
            orderedTracking.push(['referrer', document.referrer]);
        }

        // Convert ordered pairs to a proper object (preserving order)
        for (const [key, value] of orderedTracking) {
            trackingData[key] = value;
        }

        // Save ordered JSON (use array of pairs to guarantee order)
        if (orderedTracking.length > 0) {
            const payload = JSON.stringify({ ordered: orderedTracking, data: trackingData });
            document.cookie =
                "utm_data=" + encodeURIComponent(payload) +
                "; path=/; max-age=2592000; SameSite=Lax";
        }
    } catch (e) {
        console.warn("Tracking data collection failed:", e);
    }
})();
