#PFS-2392

DROP INDEX IDX_GP_ELM ON AGroup_permissions;
# Prepare table AGroup_permissions: Remove duplicate entries from table
CREATE TABLE AGroup_permissions_Dupes (AGroup_oid nvarchar(255) not null, element nvarchar(255) not null, count integer not null);
INSERT INTO AGroup_permissions_Dupes (AGroup_oid, element, count)
    SELECT AGroup_oid, element, count(*) AS count FROM AGroup_permissions GROUP BY AGroup_oid, element;
DELETE FROM AGroup_permissions;
INSERT INTO AGroup_permissions (AGroup_oid, element) SELECT AGroup_oid, element FROM AGroup_permissions_Dupes;
DROP TABLE AGroup_permissions_Dupes;
# Add primary key constraint
ALTER TABLE AGroup_permissions ALTER COLUMN element nvarchar(255) NOT NULL;
ALTER TABLE AGroup_permissions ADD CONSTRAINT PK_AGroup_permissions PRIMARY KEY (AGroup_oid, element);
# Re-add index
CREATE INDEX IDX_GP_ELM ON AGroup_permissions (element);


DROP INDEX IDX_AP_ELM ON Account_permissions;
# Prepare table Account_permissions: Remove duplicate entries from table
CREATE TABLE Account_permissions_Dupes (Account_oid nvarchar(255) not null, element nvarchar(255) not null, count integer not null);
INSERT INTO Account_permissions_Dupes (Account_oid, element, count)
    SELECT Account_oid, element, count(*) AS count FROM Account_permissions GROUP BY Account_oid, element;
DELETE FROM Account_permissions;
INSERT INTO Account_permissions (Account_oid, element) SELECT Account_oid, element FROM Account_permissions_Dupes;
DROP TABLE Account_permissions_Dupes;
# Add primary key constraint
ALTER TABLE Account_permissions ALTER COLUMN element nvarchar(255) NOT NULL;
ALTER TABLE Account_permissions ADD CONSTRAINT PK_Account_permissions PRIMARY KEY (Account_oid, element);
# Re-add index
CREATE INDEX IDX_AP_ELM ON Account_permissions (element);


# Prepare table Account_Computers: Remove duplicate entries from table
CREATE TABLE Account_Computers_Dupes (oid nvarchar(255) not null, id nvarchar(255) not null, count integer not null);
INSERT INTO Account_Computers_Dupes (id, oid, count)
    SELECT id, oid, count(*) AS count FROM Account_Computers GROUP BY id, oid;
DELETE FROM Account_Computers;
INSERT INTO Account_Computers (id, oid) SELECT id, oid FROM Account_Computers_Dupes;
DROP TABLE Account_Computers_Dupes;
# Add primary key constraint
ALTER TABLE Account_Computers ADD CONSTRAINT PK_Account_Computers PRIMARY KEY (oid, id);


# Prepare table Account_Groups: Remove duplicate entries from table
CREATE TABLE Account_Groups_Dupes (Account_oid nvarchar(255) not null, AGroup_oid nvarchar(255) not null, count integer not null);
INSERT INTO Account_Groups_Dupes (Account_oid, AGroup_oid, count)
    SELECT Account_oid, AGroup_oid, count(*) AS count FROM Account_Groups GROUP BY Account_oid, AGroup_oid;
DELETE FROM Account_Groups;
INSERT INTO Account_Groups (Account_oid, AGroup_oid) SELECT Account_oid, AGroup_oid FROM Account_Groups_Dupes;
DROP TABLE Account_Groups_Dupes;
# Add primary key constraint
ALTER TABLE Account_Groups ADD CONSTRAINT PK_Account_Groups PRIMARY KEY (Account_oid, AGroup_oid);


# MSSQL: SQL to remove primary keys on affected tables:
# ALTER TABLE AGroup_permissions DROP CONSTRAINT PK_AGroup_permissions;
# ALTER TABLE Account_permissions DROP CONSTRAINT PK_Account_permissions;
# ALTER TABLE Account_Computers DROP CONSTRAINT PK_Account_Computers;
# ALTER TABLE Account_Groups DROP CONSTRAINT PK_Account_Groups;
