CREATE TABLE activityitem (
    id varchar(32) NOT NULL,
    creationdate timestamp NOT NULL,
    type varchar(255),
    file_activity_id varchar(32),
    initiator_account_id varchar(255),
    invitation_activity_id varchar(32),
    permission_activity_id varchar(32)
);
CREATE TABLE fileactivity (
    id varchar(32) NOT NULL,
    modificationdate timestamp,
    relativepath varchar(1024),
    folder_id varchar(255)
);
CREATE TABLE permissionactivity (
    id varchar(32) NOT NULL,
    permissiontype varchar(255),
    folder_id varchar(255),
    recipient_account_id varchar(255)
);
CREATE TABLE invitationactivity (
    id varchar(32) NOT NULL,
    permissiontype varchar(255),
    folder_id varchar(255),
    recipient_account_id varchar(255)
);

ALTER TABLE activityitem
    ADD CONSTRAINT activityitem_pkey PRIMARY KEY (id);
ALTER TABLE fileactivity
    ADD CONSTRAINT fileactivity_pkey PRIMARY KEY (id);
ALTER TABLE permissionactivity
    ADD CONSTRAINT permissionactivity_pkey PRIMARY KEY (id);
ALTER TABLE invitationactivity
    ADD CONSTRAINT invitationactivity_pkey PRIMARY KEY (id);

ALTER TABLE activityitem
    ADD CONSTRAINT fk6adc16e248795eb2 FOREIGN KEY (file_activity_id) REFERENCES fileactivity(id);
ALTER TABLE activityitem
    ADD CONSTRAINT fk6adc16e29ba772c FOREIGN KEY (invitation_activity_id) REFERENCES invitationactivity(id);
ALTER TABLE activityitem
    ADD CONSTRAINT fk6adc16e2aa66dc98 FOREIGN KEY (permission_activity_id) REFERENCES permissionactivity(id);
ALTER TABLE activityitem
    ADD CONSTRAINT fk6adc16e2f74482f3 FOREIGN KEY (initiator_account_id) REFERENCES account(oid) ON DELETE SET NULL;

CREATE INDEX "IDX_ACTIVITY_TYPE" ON activityitem (type);

ALTER TABLE fileactivity
    ADD CONSTRAINT fk5b8264cbd5300dd7 FOREIGN KEY (folder_id) REFERENCES folderinfo(id);

ALTER TABLE permissionactivity
    ADD CONSTRAINT fk87d09a1eacf99cc9 FOREIGN KEY (recipient_account_id) REFERENCES account(oid) ON DELETE SET NULL;
ALTER TABLE permissionactivity
    ADD CONSTRAINT fk87d09a1ed5300dd7 FOREIGN KEY (folder_id) REFERENCES folderinfo(id);

ALTER TABLE invitationactivity
    ADD CONSTRAINT fk13a8e1e8acf99cc9 FOREIGN KEY (recipient_account_id) REFERENCES account(oid) ON DELETE SET NULL;
ALTER TABLE invitationactivity
    ADD CONSTRAINT fk13a8e1e8d5300dd7 FOREIGN KEY (folder_id) REFERENCES folderinfo(id);
