CREATE TABLE ActivityItem (
    id varchar(32) NOT NULL,
    creationdate timestamp NOT NULL,
    type varchar(255),
    file_activity_id varchar(32),
    initiator_account_id varchar(255),
    invitation_activity_id varchar(32),
    permission_activity_id varchar(32)
);
CREATE TABLE FileActivity (
    id varchar(32) NOT NULL,
    modificationdate timestamp,
    relativepath varchar(1024),
    folder_id varchar(255)
);
CREATE TABLE PermissionActivity (
    id varchar(32) NOT NULL,
    permissiontype varchar(255),
    folder_id varchar(255),
    recipient_account_id varchar(255)
);
CREATE TABLE InvitationActivity (
    id varchar(32) NOT NULL,
    permissiontype varchar(255),
    folder_id varchar(255),
    recipient_account_id varchar(255)
);

ALTER TABLE ActivityItem
    ADD CONSTRAINT ActivityItem_pkey PRIMARY KEY (id);
ALTER TABLE FileActivity
    ADD CONSTRAINT FileActivity_pkey PRIMARY KEY (id);
ALTER TABLE PermissionActivity
    ADD CONSTRAINT PermissionActivity_pkey PRIMARY KEY (id);
ALTER TABLE InvitationActivity
    ADD CONSTRAINT InvitationActivity_pkey PRIMARY KEY (id);

ALTER TABLE ActivityItem
    ADD CONSTRAINT fk6adc16e248795eb2 FOREIGN KEY (file_activity_id) REFERENCES FileActivity(id);
ALTER TABLE ActivityItem
    ADD CONSTRAINT fk6adc16e29ba772c FOREIGN KEY (invitation_activity_id) REFERENCES InvitationActivity(id);
ALTER TABLE ActivityItem
    ADD CONSTRAINT fk6adc16e2aa66dc98 FOREIGN KEY (permission_activity_id) REFERENCES PermissionActivity(id);
ALTER TABLE ActivityItem
    ADD CONSTRAINT fk6adc16e2f74482f3 FOREIGN KEY (initiator_account_id) REFERENCES Account(oid) ON DELETE SET NULL;

CREATE INDEX IDX_ACTIVITY_TYPE ON ActivityItem (type);

ALTER TABLE FileActivity
    ADD CONSTRAINT fk5b8264cbd5300dd7 FOREIGN KEY (folder_id) REFERENCES FolderInfo(id);

ALTER TABLE PermissionActivity
    ADD CONSTRAINT fk87d09a1eacf99cc9 FOREIGN KEY (recipient_account_id) REFERENCES Account(oid) ON DELETE SET NULL;
ALTER TABLE PermissionActivity
    ADD CONSTRAINT fk87d09a1ed5300dd7 FOREIGN KEY (folder_id) REFERENCES FolderInfo(id);

ALTER TABLE InvitationActivity
    ADD CONSTRAINT fk13a8e1e8acf99cc9 FOREIGN KEY (recipient_account_id) REFERENCES Account(oid) ON DELETE SET NULL;
ALTER TABLE InvitationActivity
    ADD CONSTRAINT fk13a8e1e8d5300dd7 FOREIGN KEY (folder_id) REFERENCES FolderInfo(id);
