// ****************************************************************************
// API ************************************************************************
// ****************************************************************************

function showCMPEngineApp(auto) {
	setActiveApp("cmp_engine");
	autoRefreshStatus(auto);
	
	$("#command").focus(function() {
		autoRefreshStatus(false);
	});
	$("#Send").hover(function() {
		autoRefreshStatus(false);
	});
}

function hideCMPEngineApp() {
	autoRefreshStatus(false);
}

// ****************************************************************************
// LOGIC **********************************************************************
// ****************************************************************************

var refreshTimer;

function refresh() {
	
	$('#logcontainer').load('?', {
		action : "refresh",
		command : $('#command').val(),
		CSRFToken : csrf_token
	}, function() {
		$("#command").focus(function() {
			autoRefreshStatus(false);
		});
		$("#Send").hover(function() {
			autoRefreshStatus(false);
		});
	});
}

function autoRefreshStatus(auto) {
	if (refreshTimer) {
		window.clearInterval(refreshTimer);
		refreshTimer = null;
	}
	if (auto) {
		refreshTimer = window.setInterval("refresh()", 1000);
		refresh();
		$('#pauseButton').show();
		$('#playButton').hide();
	} else {
		$('#pauseButton').hide();
		$('#playButton').show();
	}
}
