/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

if (!window.Picasso.hasOwnProperty("Actionbar")) {
    window.Picasso.Actionbar = {};
}

/**
 * Some custom attributes for specific behavior are used:
 *
 * data-search-keys - Search kesy for this column/row
 **/

/* Private scope */
(function () {

    /* Globals */
    var ONFILTER = null;

    /**
     * Remove all elements right of
     *
     * @param {Event}  e  Click event
     **/

    var removeSiblings = function (e) {
        $(this).nextAll("a.pica-crumb").remove();

        if ($(this).data("file")) {
            sessionStorage.setItem("navigationHistory", $(this).data("file"));
        }else {
            sessionStorage.removeItem("navigationHistory");
        }


        recalculate();
    };

    /**
     * Handle press of enter on search bar
     *
     * @param {String}  val  Input value
     **/

    var handleKeyEnter = function (val) {
        $(this).val("");

        /* Either call search func or show all elements again */
        if (ONFILTER) {
            ONFILTER(val, 0);
        } else {
            $("[data-search-keys]").show();
        }
    };

    /**
     * Handle press of esc on search bar
     *
     * @param {String}  val  Input value
     **/

    var handleKeyEsc = function (val) {
        $(this).val("");

        /* Show all elements again */
        $("[data-search-keys]").show();

        /* Run filter handler if any */
        if (ONFILTER) {
            ONFILTER("", 0);
        }
    };

    /**
     * Handle other keys on search bar
     *
     * @param {String}  char  Pressed char
     * @param {String}  val   Content of search bar input
     **/

    var handleKeyElse = function (char, val) {
        var elems = $("[data-search-keys]");
        var nmatches = 0;

        /* Hide non-matching elements or show all of them again */
        if (0 < val.length) {
            val = Picasso.Helper.escapeRegExp(val);
            var re = new RegExp(val, "gi");

            elems.each(function () {
                var that = $(this);
                const test = (element) => String(element).match(re);
                if (that.data("search-keys").split(",").some(test)) {
                    that.show();

                    nmatches++;
                } else {
                    that.hide();
                }
            });
        } else {
            elems.show();
        }

        if (nmatches) {
            for (let key in Picasso.Helper.xhrPool){
                if (Array.isArray(Picasso.Helper.xhrPool[key]) && Picasso.Helper.xhrPool[key].length > 0) {
                    Picasso.Helper.abortAll(key)
                }
            }
        }

        /* Run filter handler if any */
        if (ONFILTER) {
            ONFILTER(val, nmatches);
        }
    };

    /**
     * Recalculate width of input field
     **/

    var recalculate = function () {
        var div = $("#pica_action_search");
        var input = $("#pica_action_search_input");
        var button = $("#pica_action_search_button");

        /* Count width of all crumbs */
        var elems = div.find("a.pica-crumb");
        var width = 0;

        for (var i = 0; i < elems.length; i++) {
            width += $(elems[i]).outerWidth();
        }

        input.css("width",
            (div.innerWidth() - width - button.innerWidth() - 50) + "px");
    };

    /**
     * Add breadcrumb to search bar
     *
     * @param {String}   name     Name of the crumb
     * @param {Function} onClick  Click handler
     * @param {String}   klass    Classes to add to element
     **/

    Picasso.Actionbar.addCrumb = function (name, onClick, klass) {
        var a = $("<a>", {
            class: "pica-crumb"
        });

        var span = $("<span>", {
            text: name,
            class: klass
        });

        /* Handle click handler */
        if (onClick) a.click(onClick);
        a.click(removeSiblings);

        a.append(span);

        $("#pica_action_search_input").before(a);

        recalculate();

        return a;
    };

    /**
     * Set filter handler
     *
     * @param {Function}  onFilter  Filter handler
     **/

    Picasso.Actionbar.setFilterHandler = function (onFilter) {
        if (onFilter) {
            ONFILTER = onFilter;
        }
    };

    /* Handle statically added crumbs */
    $(".pica-crumb").click(removeSiblings);

    recalculate();

    /* Bind handlers */
    $(window).resize(recalculate);

    Picasso.Helper.handleEnterEscElse("#pica_action_search_input",
        handleKeyEnter, handleKeyEsc, Picasso.Helper.debounce(
            handleKeyElse, 500));
})();

