/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

/* Private scope */
(function () {


    var ary =[]
    var path
    var uploaderEmail

    /**
     * Create link and call handlers
     *
     * @param {Function}  onSuccess  Success handler
     **/

    var createLink = function (onSuccess) {

        /* Assemble data */
        var url = "/wapi/filelink";
        var data = {
            action: "prepareLink",
            folderID: $("#preparelink_folder_id").val(),
            username: $("#preparelink_username").val(),
            mail: $("#preparelink_mail").val()
        };

        /* Fire ajax */
        Picasso.Helper.fireAjax(url, data, onSuccess,

            /* Error */
            function (e, status) {
                Picasso.Notification.show(Picasso.Lang.get(
                    "notification_error_create",
                    Picasso.Lang.get("label_links")), "danger");

                Picasso.debugLog(e);
            }
        );
    };

    /**
     * Create and show upload dialog
     **/

    var showUploadDialog = function (ary) {

        var dialog = new Picasso.Dialog.Upload(
            Picasso.Lang.get("dialog_title_upload"),
            Picasso.Lang.get("dialog_body_upload",
                Picasso.Lang.get(Picasso.Lang.Flags.DOWNCASE,
                    "label_links")));

        /* Upload directories not supported by IE */
        if (Picasso.Helper.isInternetExplorer()) {

            /* Prevent file upload */
            var fileUploadDialog = dialog._dialog.find("#upload_input_directories");
            fileUploadDialog.get(0).type = "button";

            var uploadDirsElem = dialog._dialog.find("#upload_directory");
            var uploadDirsButton = $(uploadDirsElem[0]);

            /* Rebind click handler */
            uploadDirsButton.off("click").on("click", function () {

                var warningDialog = new Picasso.Dialog("#ie_warning_dialog",
                    Picasso.Lang.get("dialog_title_ie_warning"),
                    Picasso.Lang.get("dialog_body_ie_warning"));

                /* Bring warning dialog to the top */
                $(warningDialog._dialog[0]).css("z-index", 1100);

                warningDialog.show();
            });
        }

        dialog.setUrl("/ul/" + ary[0].ID);
        let username =ary[0].name;
        let uploaderEmail = "";
        if (ary[1]) {
            uploaderEmail=ary[1].mail;
        }
        var data = {
            "uploadName" :username,
            "uploadMail" :uploaderEmail,
            "fileLinkId" :ary[0].ID
        }
        dialog.setData(data);
        dialog.show();
    };

    /**
     * Handle click on upload button the first time
     *
     * @param e
     **/

    var handleFirstClickUpload = function (e) {
        createLink(
            /* Success */
            function (json) {
                path =$("#preparelink_username").val()
                uploaderEmail =$("#preparelink_mail").val()
                ary = Picasso.Helper.getResultArray(json);

                if (0 < ary.length) {
                    showUploadDialog(ary)
                    $("#preparelink_upload").unbind('click',handleFirstClickUpload)
                    $("#preparelink_upload").off("click").click(handleClickUpload)
                }
            }
        );
    };

    /**
     * Handle click on upload button
     *
     * @param e
     **/

    var handleClickUpload = function (e) {
        /* Validate required fields */
        if (!Picasso.Helper.validateInputs(".pica-dialog")) {
            Picasso.Notification.show(
                Picasso.Lang.get("notification_error_missing_fields"),
                "warning");

            return;
        }
        if (path === $("#preparelink_username").val() && uploaderEmail === $("#preparelink_mail").val()) {
            if (0 < ary.length) {
                showUploadDialog(ary)
            }
        }else {

        handleFirstClickUpload(e);
        }

    };

    /**
     * Handle click on create button
     *
     * @param e
     **/

    var handleClickCreate = function (e) {
        createLink(

            /* Success */
            function (json) {
                var ary = Picasso.Helper.getResultArray(json);

                var url = ary[0].link;

                window.location.href = url;
            }
        );
    };

    /* Bind handlers */
    $("#preparelink_upload").click(handleClickUpload);
    $("#preparelink_create").click(handleClickCreate);

})();
