/* jshint strict: true, trailing: true, loopfunc: true, browser: true, jquery: true, devel: true, maxerr: 500 */
"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

if (!window.Picasso.hasOwnProperty("News")) {
    window.Picasso.News = {};
}

/* Private scope */
(function () {


    /**
     * Handle click on news File Element
     *
     * @param {Event}  e  Click event
     **/

    var handleClickFile = function (e) {
        e.preventDefault();
        e.stopPropagation();

        var file = $(this).data("file");

        var url = file.openURL ? file.openURL : file.resourceURL;

        if (Picasso.get("isFederated")) {
            url += "?CSRFToken=" + Picasso.get("CSRF");
        }
        var a = $("<a>", {
            href: url,
            target: "_blank"
        });

        $("body").append(a);
        a[0].click();
        a.remove();
    };

    var renderFile = function (file, klass) {
        var glyph = Picasso.Helper.createGlyph(
            "filetypes filetypes-" + file.ext.toLowerCase(), "pica-glyph-color");

        /* Check if glyph was found: Detection here is rather tricky, because
         *                           we cannot access :after elements, which
         *                           aren't part of the DOM */
        $("body").append(glyph);

        if (0 === parseInt(glyph.css("width"))) {
            glyph.addClass("filetypes-unknown");
        }

        glyph.addClass(klass);
        glyph.attr("data-tooltip", "tooltip_file");
        glyph.attr("data-placement", "bottom");
        if (file.modifiedByAccount) {
            glyph.attr("title", Picasso.Lang.get("tooltip_file_modifiedby", file.path, Picasso.Helper.formatSize(file.size), file.modifiedByAccount));
        } else {
            glyph.attr("title", Picasso.Lang.get("tooltip_file", file.path, Picasso.Helper.formatSize(file.size)));
        }
        glyph.data("file", file);
        glyph.click(handleClickFile)
        glyph.tooltip({ container: "body" });

        return glyph;
    };

    /**
     * Render given json object
     *
     * @param {Object}  obj  Given json object
     * @returns {*}
     */

    var renderNews = function (obj) {
        var entry = $("<li>", { class: "pica-timeline-item" });

        /* Date */
        var div = $("<div>", {
            class: "pica-timeline-info"
        });

        var span = $("<span>", {
            "data-tooltip": "",
            "data-placement": "bottom",
            title: Picasso.Helper.formatAge(obj.date),
            text: Picasso.Helper.formatDate(obj.date)
        });

        span.tooltip({ container: "body" });

        div.append(span);
        entry.append(div);

        /* Marker */
        entry.append($("<div>", { class: "pica-timeline-marker" }));

        /* Content */
        var content = $("<div>", { class: "pica-timeline-content" });

        content.append($("<h3>", {
            html: $("<a>", {
                class: "pica-action-link",
                text: obj.folder.name
                // FIXME: href: "/files/" + obj.folder.ID
            })
        }));

        var nfiles = 0;
        var files = $("<div>", { class: "pica-timeline-files" });

        /* Add added/updated files */
        $.each(obj.newFiles, function () {
            files.append(renderFile(this, "text-info"))
            nfiles++;
        });

        $.each(obj.updatedFiles, function () {
            files.append(renderFile(this, "text-warning"));
            nfiles++;
        });

        $.each(obj.deletedFiles, function () {
            files.append(renderFile(this, "text-danger"));
            nfiles++;
        });

        content.append(files);
        entry.append(content);

        return (0 < nfiles ? entry : null); ///< Skip news without affected files (shrug)
    };

    /**
     * Fetch JSON data
     **/

    Picasso.News.fetch = function () {
        var url = "/wapi/news";
        var data = {
            action: "getAll",
            accountOID: Picasso.get("accountOid"),
        };

        Picasso.Helper.fireAjax(url, data,

            /* onSuccess */
            function (json) {
                try {
                    var fragment = $("<ul>", {
                        class: "pica-timeline pica-timeline-centered"
                    });
                    var ary = Picasso.Helper.getResultArray(json);

                    $.each(ary, function () {
                        var rendered = renderNews(this);

                        if (null != rendered) {
                            fragment.append(rendered);
                        }
                    });

                    if (0 === ary.length) {
                        var li = $("<li>", {
                            class: "pica-highlight pica-line-big warning text-center",
                            text: Picasso.Lang.get("string_nothing_found")
                        });

                        fragment.append(li);
                    }

                    $(".pica-timeline").replaceWith(fragment);

                    $('[data-toggle="tooltip"]').tooltip();
                } catch (e) {
                    Picasso.debugLog(e);

                    return;
                }
            },

            /* onError */
            function (e) {
                Picasso.debugLog(e);
            }
        );
    };

    /* Init */
    Picasso.News.fetch();
})();


