"use strict";

if (!window.hasOwnProperty("Picasso")) {
    window.Picasso = {};
}

(function () {

    /**
     * A domain object describing one plan (e.g. Starter, Pro, Elite)
     * that holds both monthly and yearly attributes.
     *
     * @constructor
     * @param {Object|string} data - Either a JSON string or an object containing plan data.
     */
    Picasso.Plan = function (data) {
        var json = Picasso.Helper.tryJSON(data);

        // Plan name
        this._name = Picasso.Helper.getPropOrDefValue(json, "", "name");
        this._isCurrentPlan = Picasso.Helper.getPropOrDefValue(json, "", "isCurrentPlan");
        this._isDisabled = Picasso.Helper.getPropOrDefValue(json, false, "isDisabled");

        // Monthly fields
        var monthly = (json && json.monthly) || {};
        this._monthlyPrice    = Picasso.Helper.getPropOrDefValue(monthly, 0, "price");
        this._monthlyCurrency = Picasso.Helper.getPropOrDefValue(monthly, "EUR", "currency");
        this._monthlyPriceId  = Picasso.Helper.getPropOrDefValue(monthly, "", "priceId");
        this._monthlyDesc     = Picasso.Helper.getPropOrDefValue(monthly, "", "desc");
        this._monthlyMetaData = Picasso.Helper.getPropOrDefValue(monthly, [], "metadata");

        // Yearly fields
        var yearly = (json && json.yearly) || {};
        this._yearlyPrice    = Picasso.Helper.getPropOrDefValue(yearly, 0, "price");
        this._yearlyCurrency  = Picasso.Helper.getPropOrDefValue(yearly, "EUR", "currency");
        this._yearlyPriceId  = Picasso.Helper.getPropOrDefValue(yearly, "", "priceId");
        this._yearlyDesc     = Picasso.Helper.getPropOrDefValue(yearly, "", "desc");
        this._yearlyMetaData = Picasso.Helper.getPropOrDefValue(yearly, [], "metadata");
        this._yearlyPriceIsDefault = Picasso.Helper.getPropOrDefValue(yearly, false, "priceIsDefault");

        // Return a proxy to catch getter/setter calls (if Picasso.Helper.createProxy is defined)
        return Picasso.Helper.createProxy(this);
    };

    /**
     * Returns a string representation of the plan.
     *
     * @returns {String} The plan name.
     */
    Picasso.Plan.prototype.toString = function () {
        return this._name;
    };

})();
